/*
 * Decompiled with CFR 0.152.
 */
package com.help.service;

import com.help.dao.PUserConfigMapper;
import com.help.domain.PUserConfig;
import com.help.domain.PUserConfigExample;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserConfigService {
    @Autowired
    private PUserConfigMapper mapper;

    @Transactional
    public void save(String userNo, String name, String value) {
        PUserConfigExample example = new PUserConfigExample();
        example.createCriteria().andUserNoEqualTo(userNo).andNameEqualTo(name);
        PUserConfig config = new PUserConfig();
        config.setUserNo(userNo);
        config.setName(name);
        config.setValue(value);
        if (this.mapper.updateColumnsByExample(config, example, "value") == 0) {
            this.mapper.insert(config);
        }
    }

    public boolean contain(String userNo, String name) {
        PUserConfigExample example = new PUserConfigExample();
        example.createCriteria().andUserNoEqualTo(userNo).andNameEqualTo(name);
        return this.mapper.countByExample(example) > 0L;
    }

    public String get(String userNo, String name) {
        PUserConfig config = this.mapper.selectByPrimaryKey(userNo, name);
        if (config != null) {
            return config.getValue();
        }
        return null;
    }

    public void delete(String userNo, String name) {
        this.mapper.deleteByPrimaryKey(userNo, name);
    }

    public Map<String, String> list(String userNo) {
        PUserConfigExample example = new PUserConfigExample();
        example.createCriteria().andUserNoEqualTo(userNo);
        return this.mapper.selectByExample(example).stream().collect(Collectors.toMap(PUserConfig::getName, PUserConfig::getValue));
    }
}

