/*
 * Decompiled with CFR 0.152.
 */
package com.help.service;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.dao.PRoleModuleOpMapper;
import com.help.domain.PRoleModuleOpExample;
import com.help.storage.IDeptStorage;
import com.help.storage.IOrgStorage;
import com.help.storage.IRoleStorage;
import com.help.storage.IUserStorage;
import com.help.storage.editable.IEditableRoleStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UnionService {
    @Autowired
    IUserStorage iUserStorage;
    @Autowired
    IRoleStorage iRoleStorage;
    @Autowired
    IOrgStorage iOrgStorage;
    @Autowired
    IDeptStorage iDeptStorage;
    @Autowired
    PRoleModuleOpMapper pRoleModuleOpMapper;

    @Transactional
    public void deleteRole(String roleNo) {
        if (!(this.iRoleStorage instanceof IEditableRoleStorage)) {
            throw new UnifyException(UnifyErrorCode.NON_INTERFACE, "\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301\u89d2\u8272\u7684\u5220\u9664\u64cd\u4f5c");
        }
        ((IEditableRoleStorage)this.iRoleStorage).delete(roleNo);
        PRoleModuleOpExample pRoleMenuOpExample = new PRoleModuleOpExample();
        pRoleMenuOpExample.createCriteria().andRoleNoEqualTo(roleNo);
        this.pRoleModuleOpMapper.deleteByExample(pRoleMenuOpExample);
    }
}

