/*
 * Decompiled with CFR 0.152.
 */
package com.help.service;

import com.help.LoginInfo;
import com.help.domain.UserAffiliationInfo;
import com.help.domain.permission.Operation;
import com.help.service.IPermissionService;
import com.help.service.PermissionService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionServiceProxy
implements IPermissionService {
    @Autowired
    PermissionService permissionService;

    public boolean check(LoginInfo loginInfo, String module, String option) {
        return this.permissionService.listModuleOps(loginInfo).stream().anyMatch(p -> p.getModule().equalsIgnoreCase(module) && p.getOp().equalsIgnoreCase(option));
    }

    public boolean check(LoginInfo loginInfo, Operation operation) {
        return this.check(loginInfo, operation.getModule(), operation.getOp());
    }

    public List<Operation> list(LoginInfo loginInfo) {
        return this.permissionService.listModuleOps(loginInfo);
    }

    public List<String> listRoles(String userNo) {
        return this.permissionService.listRoleNos(userNo, null, null, false);
    }

    public List<UserAffiliationInfo> listUserAffiliations(String userNo) {
        return this.permissionService.listAffiliations(userNo);
    }
}

