/*
 * Decompiled with CFR 0.152.
 */
package com.help.service;

import com.help.LoginInfo;
import com.help.ModuleAnalasys;
import com.help.common.ICacheable;
import com.help.common.util.StringUtil;
import com.help.config.HelpManageConfig;
import com.help.dao.PMenuMapper;
import com.help.dao.PRoleModuleOpMapper;
import com.help.dao.batch.BatchHelper;
import com.help.domain.DeptInfo;
import com.help.domain.OrgInfoBase;
import com.help.domain.PMenu;
import com.help.domain.PMenuExample;
import com.help.domain.PRoleModuleOp;
import com.help.domain.PRoleModuleOpExample;
import com.help.domain.RoleInfo;
import com.help.domain.UserAffiliationInfo;
import com.help.domain.permission.Module;
import com.help.domain.permission.Operation;
import com.help.storage.IDeptStorage;
import com.help.storage.IOrgStorage;
import com.help.storage.IRoleStorage;
import com.help.storage.IUserAffiliationStorage;
import com.help.web.module.RoleModuleOp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PermissionService
implements ICacheable {
    @Autowired
    private PMenuMapper pMenuMapper;
    @Autowired
    private PRoleModuleOpMapper PRoleModuleOpMapper;
    @Autowired
    private IUserAffiliationStorage iUserAffiliationStorage;
    @Autowired
    private IRoleStorage iRoleStorage;
    @Autowired
    private IOrgStorage iOrgStorage;
    @Autowired
    private IDeptStorage iDeptStorage;
    @Autowired
    private ModuleAnalasys moduleAnalasys;
    @Autowired
    CacheManager cacheManager;
    @Autowired
    BatchHelper batchHelper;
    @Autowired
    HelpManageConfig helpManageConfig;

    public List<RoleInfo> listRoles(String userNo) {
        return this.listRoles(userNo, null, null, true);
    }

    public List<String> listRoleNos(String userNo) {
        return this.listRoleNos(userNo, null, null, true);
    }

    public List<String> listRoleNos(String userNo, String orgNo, String deptNo, boolean emptyWithAll) {
        Stream<Object> stream = ((PermissionService)AopContext.currentProxy()).listAffiliations(userNo).stream();
        stream = StringUtil.isNotEmpty((String)orgNo) && StringUtil.isNotEmpty((String)deptNo) ? stream.filter(p -> "".equalsIgnoreCase(p.getAffiType()) || "ORG".equalsIgnoreCase(p.getAffiType()) && orgNo.equalsIgnoreCase(p.getAffiNo()) || "DEPT".equalsIgnoreCase(p.getAffiType()) && deptNo.equalsIgnoreCase(p.getAffiNo())) : (StringUtil.isNotEmpty((String)orgNo) ? (emptyWithAll ? stream.filter(p -> "".equalsIgnoreCase(p.getAffiType()) || "ORG".equalsIgnoreCase(p.getAffiType()) && orgNo.equalsIgnoreCase(p.getAffiNo()) || "DEPT".equalsIgnoreCase(p.getAffiType())) : stream.filter(p -> "".equalsIgnoreCase(p.getAffiType()) || "ORG".equalsIgnoreCase(p.getAffiType()) && orgNo.equalsIgnoreCase(p.getAffiNo()))) : (StringUtil.isNotEmpty((String)deptNo) ? (emptyWithAll ? stream.filter(p -> "".equalsIgnoreCase(p.getAffiType()) || "DEPT".equalsIgnoreCase(p.getAffiType()) && deptNo.equalsIgnoreCase(p.getAffiNo()) || "ORG".equalsIgnoreCase(p.getAffiType())) : stream.filter(p -> "".equalsIgnoreCase(p.getAffiType()) || "DEPT".equalsIgnoreCase(p.getAffiType()) && deptNo.equalsIgnoreCase(p.getAffiNo()))) : (emptyWithAll ? stream.filter(p -> "".equalsIgnoreCase(p.getAffiType()) || "DEPT".equalsIgnoreCase(p.getAffiType()) || "ORG".equalsIgnoreCase(p.getAffiType())) : stream.filter(p -> "".equalsIgnoreCase(p.getAffiType())))));
        List<String> roles = stream.map(p -> p.getRoleNo()).distinct().collect(Collectors.toList());
        if (!roles.contains("default")) {
            roles.add("default");
        }
        return roles;
    }

    public List<RoleInfo> listRoles(String userNo, String orgNo, String deptNo, boolean emptyWithAll) {
        return this.iRoleStorage.getAll(this.listRoleNos(userNo, orgNo, deptNo, emptyWithAll).toArray(new String[0]));
    }

    public List<UserAffiliationInfo> listAffiliations(String userNo) {
        return this.iUserAffiliationStorage.listRoleAffiliationByUser(userNo);
    }

    public List<OrgInfoBase> listOrgs(String userNo) {
        List<String> orgs = this.listAffiliations(userNo).stream().filter(p -> "ORG".equalsIgnoreCase(p.getAffiType())).map(p -> p.getAffiNo()).distinct().collect(Collectors.toList());
        return this.iOrgStorage.getAll(orgs.toArray(new String[0]));
    }

    public List<DeptInfo> listDepts(String userNo) {
        List<String> depts = this.listAffiliations(userNo).stream().filter(p -> "DEPT".equalsIgnoreCase(p.getAffiType())).map(p -> p.getAffiNo()).distinct().collect(Collectors.toList());
        return this.iDeptStorage.getAll(depts.toArray(new String[0]));
    }

    @Deprecated
    public List<PMenu> listAllMenus() {
        PMenuExample example = new PMenuExample();
        example.setOrderByClause("ORDERNO ASC");
        return this.pMenuMapper.selectByExample(example);
    }

    @Deprecated
    public List<PMenu> listMenus(LoginInfo loginInfo) {
        List<Operation> operations = this.listModuleOps(loginInfo);
        List<PMenu> allMenus = this.listAllMenus();
        if (this.helpManageConfig.isDisablePermission()) {
            return allMenus;
        }
        return allMenus.stream().filter(p -> StringUtil.isEmpty((String)p.getModuleNo()) || operations.stream().anyMatch(o -> o.getModule().equalsIgnoreCase(p.getModuleNo()) && o.getOp().equalsIgnoreCase(StringUtil.nvl((String)p.getOp(), (String)"visit")))).collect(Collectors.toList());
    }

    public List<Operation> listModuleOps(LoginInfo loginInfo) {
        if (this.helpManageConfig.isDisablePermission()) {
            return this.moduleAnalasys.listOps();
        }
        List rs = loginInfo.getLoginRoles();
        if (rs == null || rs.size() == 0) {
            return new ArrayList<Operation>();
        }
        return ((PermissionService)AopContext.currentProxy()).listModuleOpsByRolesCache(rs.stream().sorted().collect(Collectors.toList()).toArray(new String[0]));
    }

    @Cacheable(value={"permission"})
    public List<Operation> listModuleOpsByRolesCache(String ... roleNos) {
        if (this.helpManageConfig.isDisablePermission()) {
            return this.moduleAnalasys.listOps();
        }
        if (roleNos != null && roleNos.length > 0) {
            List<String> roles = Arrays.asList(roleNos);
            List<Operation> allOps = this.moduleAnalasys.listOps();
            PRoleModuleOpExample PRoleModuleOpExample2 = new PRoleModuleOpExample();
            PRoleModuleOpExample2.createCriteria().andRoleNoIn((List)roles);
            List list = this.PRoleModuleOpMapper.selectByExample(PRoleModuleOpExample2).stream().filter(p -> allOps.stream().anyMatch(q -> p.getModuleNo().equalsIgnoreCase(q.getModule()) && p.getOpNo().equalsIgnoreCase(q.getOp()))).map(p -> {
                Operation info = new Operation();
                info.setModule(p.getModuleNo());
                info.setOp(p.getOpNo());
                return info;
            }).collect(Collectors.toList());
            if (roles.stream().anyMatch(p -> "admin".equalsIgnoreCase((String)p))) {
                return this.sum(list, this.moduleAnalasys.listSystemOps(), this.moduleAnalasys.listGrantToAll());
            }
            return this.sum(list, this.moduleAnalasys.listGrantToAll());
        }
        return this.moduleAnalasys.listGrantToAll();
    }

    public List<Operation> listPermission(String roleNo, String moduleNo) {
        Module module;
        if (this.helpManageConfig.isDisablePermission()) {
            Module m = this.moduleAnalasys.get(moduleNo);
            if (m != null) {
                return m.getOperations();
            }
            return new ArrayList<Operation>();
        }
        if (StringUtil.isEmpty((String)moduleNo)) {
            return new ArrayList<Operation>();
        }
        List<Operation> allOps = this.moduleAnalasys.listOps();
        PRoleModuleOpExample PRoleModuleOpExample2 = new PRoleModuleOpExample();
        PRoleModuleOpExample2.createCriteria().andRoleNoEqualTo(roleNo).andModuleNoEqualTo(moduleNo);
        List list = this.PRoleModuleOpMapper.selectByExample(PRoleModuleOpExample2).stream().filter(p -> allOps.stream().anyMatch(q -> p.getModuleNo().equalsIgnoreCase(q.getModule()) && p.getOpNo().equalsIgnoreCase(q.getOp()))).map(p -> {
            Operation info = new Operation();
            info.setModule(p.getModuleNo());
            info.setOp(p.getOpNo());
            return info;
        }).collect(Collectors.toList());
        if ("admin".equalsIgnoreCase(roleNo) && (module = this.moduleAnalasys.get(moduleNo)) != null && "1".equalsIgnoreCase(module.getSystem())) {
            return this.sum(list, module.getOperations());
        }
        return this.sum(list, this.moduleAnalasys.listGrantToAll().stream().filter(p -> p.getModule().equalsIgnoreCase(moduleNo)).collect(Collectors.toList()));
    }

    public void grantPermission(RoleModuleOp op) {
        PRoleModuleOp PRoleModuleOp2 = new PRoleModuleOp();
        PRoleModuleOp2.setRoleNo(op.getRoleNo());
        PRoleModuleOp2.setOpNo(op.getOp());
        PRoleModuleOp2.setModuleNo(op.getModuleNo());
        this.PRoleModuleOpMapper.insert(PRoleModuleOp2);
    }

    public void revokePermission(RoleModuleOp op) {
        PRoleModuleOpExample example = new PRoleModuleOpExample();
        example.createCriteria().andRoleNoEqualTo(op.getRoleNo()).andModuleNoEqualTo(op.getModuleNo()).andOpNoEqualTo(op.getOp());
        this.PRoleModuleOpMapper.deleteByExample(example);
    }

    @Transactional
    public void copy(String roleFrom, String roleTo) {
        PRoleModuleOpExample example = new PRoleModuleOpExample();
        example.createCriteria().andRoleNoEqualTo(roleFrom);
        List<PRoleModuleOp> ops = this.PRoleModuleOpMapper.selectByExample(example);
        example.clear();
        example.createCriteria().andRoleNoEqualTo(roleTo);
        List<PRoleModuleOp> opOld = this.PRoleModuleOpMapper.selectByExample(example);
        Iterator<PRoleModuleOp> its = ops.iterator();
        block0: while (its.hasNext()) {
            PRoleModuleOp o = its.next();
            for (PRoleModuleOp old : opOld) {
                if (!old.getOpNo().equals(o.getOpNo()) || !old.getModuleNo().equals(o.getModuleNo())) continue;
                its.remove();
                continue block0;
            }
        }
        this.batchHelper.getBatchExecuter(PRoleModuleOpMapper.class).execute(ops, (dao, entity) -> {
            entity.setRoleNo(roleTo);
            dao.insert((PRoleModuleOp)entity);
        });
    }

    @Transactional
    public void reset(String roleNo, String menuno, String[] actno) {
        ArrayList<PRoleModuleOp> list = new ArrayList<PRoleModuleOp>();
        for (String a : actno) {
            PRoleModuleOp op = new PRoleModuleOp();
            op.setOpNo(a);
            op.setModuleNo(menuno);
            op.setRoleNo(roleNo);
            list.add(op);
        }
        PRoleModuleOpExample exp = new PRoleModuleOpExample();
        exp.createCriteria().andRoleNoEqualTo(roleNo).andModuleNoEqualTo(menuno);
        this.PRoleModuleOpMapper.deleteByExample(exp);
        this.batchHelper.getBatchExecuter(PRoleModuleOpMapper.class).execute(list, (dao, entity) -> dao.insert((PRoleModuleOp)entity));
    }

    public void refresh() {
        this.cacheManager.getCache("permission").clear();
    }

    private List<Operation> sum(List<Operation> ... list) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        for (List<Operation> ops : list) {
            for (Operation op : ops) {
                if (result.stream().anyMatch(p -> p.getModule().equalsIgnoreCase(op.getModule()) && p.getOp().equalsIgnoreCase(op.getOp()))) continue;
                Operation o = new Operation();
                o.setModule(op.getModule());
                o.setOp(op.getOp());
                result.add(o);
            }
        }
        return result;
    }
}

