/*
 * Decompiled with CFR 0.152.
 */
package com.help.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.constraint.ISearchable;
import com.help.dao.POperationLogMapper;
import com.help.dao.batch.BatchExecuter;
import com.help.dao.batch.BatchHelper;
import com.help.dao.batch.IExecuteSingleAction;
import com.help.domain.POperationLog;
import com.help.domain.POperationLogExample;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class POperationLogService
implements ISearchable<POperationLog, POperationLogExample> {
    @Autowired
    private POperationLogMapper mapper;
    @Autowired
    private BatchHelper batchHelper;

    public POperationLog add(POperationLog entity) {
        this.mapper.insert(entity);
        return entity;
    }

    @Transactional(rollbackFor={Throwable.class})
    public void addBatch(List<POperationLog> list) {
        BatchExecuter executer = this.batchHelper.getBatchExecuter(POperationLogMapper.class);
        executer.execute(list, (IExecuteSingleAction)new IExecuteSingleAction<POperationLogMapper, POperationLog>(){

            public void execute(POperationLogMapper dao, POperationLog entity) {
                dao.insert(entity);
            }
        });
    }

    public void update(POperationLog entity) {
        if (this.mapper.updateByPrimaryKey(entity) == 0) {
            throw new UnifyException(UnifyErrorCode.NON_DATA);
        }
    }

    public void updateSelective(POperationLog entity) {
        if (this.mapper.updateByPrimaryKeySelective(entity) == 0) {
            throw new UnifyException(UnifyErrorCode.NON_DATA);
        }
    }

    public void delete(Long id) {
        if (this.mapper.deleteByPrimaryKey(id) == 0) {
            throw new UnifyException(UnifyErrorCode.NON_DATA);
        }
    }

    public POperationLog get(Long id) {
        return this.mapper.selectByPrimaryKey(id);
    }

    public List<POperationLog> list() {
        return this.mapper.selectByExample(null);
    }

    public List<POperationLog> list(POperationLogExample example, String ... columns) {
        if (columns == null || columns.length == 0) {
            return this.mapper.selectByExample(example);
        }
        return this.mapper.selectColumnsByExample(example, columns);
    }

    public UnifyPageData<POperationLog> list(UnifyPageInfo pageInfo) {
        PageHelper.startPage((int)pageInfo.getPageIndex(), (int)pageInfo.getPageSize());
        List<POperationLog> list = this.mapper.selectByExample(null);
        PageInfo info = new PageInfo(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData((Collection)info.getList(), pageInfo);
    }

    public UnifyPageData<POperationLog> list(UnifyPageInfo pageInfo, POperationLogExample example, String ... columns) {
        PageHelper.startPage((int)pageInfo.getPageIndex(), (int)pageInfo.getPageSize());
        List<POperationLog> list = null;
        list = columns == null || columns.length == 0 ? this.mapper.selectByExample(example) : this.mapper.selectColumnsByExample(example, columns);
        PageInfo info = new PageInfo(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData((Collection)info.getList(), pageInfo);
    }

    public void clean() {
        this.mapper.deleteByExample(null);
    }
}

