/*
 * Decompiled with CFR 0.152.
 */
package com.help.service;

import com.help.common.util.StringUtil;
import com.help.constraint.ISearchable;
import com.help.dao.PMenuMapper;
import com.help.dao.PRoleModuleOpMapper;
import com.help.dao.batch.BatchHelper;
import com.help.dao.batch.IExecuteSingleAction;
import com.help.domain.PMenu;
import com.help.domain.PMenuExample;
import com.help.domain.PRoleModuleOpExample;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MenuService
implements ISearchable<PMenu, PMenuExample> {
    @Autowired
    private PMenuMapper pMenuMapper;
    @Autowired
    private PRoleModuleOpMapper pRoleMenuOpMapper;
    @Autowired
    private BatchHelper batchHelper;

    public PMenu getMenu(String menuno) {
        PMenu menu = this.pMenuMapper.selectByPrimaryKey(menuno);
        if (menu != null && StringUtil.isNotEmpty((String)menu.getModuleNo()) && StringUtil.isEmpty((String)menu.getOp())) {
            menu.setOp("visit");
        }
        return menu;
    }

    public List<PMenu> list() {
        PMenuExample example = new PMenuExample();
        example.setOrderByClause("ORDERNO ASC");
        List<PMenu> list = this.pMenuMapper.selectByExample(example);
        for (PMenu menu : list) {
            if (menu == null || !StringUtil.isNotEmpty((String)menu.getModuleNo()) || !StringUtil.isEmpty((String)menu.getOp())) continue;
            menu.setOp("visit");
        }
        return list;
    }

    public List<PMenu> list(PMenuExample example, String ... columns) {
        List<PMenu> list = null;
        list = columns == null || columns.length == 0 ? this.pMenuMapper.selectByExample(example) : this.pMenuMapper.selectColumnsByExample(example, columns);
        for (PMenu menu : list) {
            if (menu == null || !StringUtil.isNotEmpty((String)menu.getModuleNo()) || !StringUtil.isEmpty((String)menu.getOp())) continue;
            menu.setOp("visit");
        }
        return list;
    }

    public List<PMenu> list(String superMenuNo) {
        PMenuExample pMenuExample = new PMenuExample();
        pMenuExample.createCriteria().andSuperMenunoEqualTo(superMenuNo);
        pMenuExample.setOrderByClause("ORDERNO ASC");
        List<PMenu> list = this.pMenuMapper.selectByExample(pMenuExample);
        for (PMenu menu : list) {
            if (menu == null || !StringUtil.isNotEmpty((String)menu.getModuleNo()) || !StringUtil.isEmpty((String)menu.getOp())) continue;
            menu.setOp("visit");
        }
        return list;
    }

    public void add(PMenu pMenu) {
        if (pMenu.getOrderno() == null) {
            pMenu.setOrderno(0);
        }
        if (StringUtil.isEmpty((String)pMenu.getSuperMenuno())) {
            pMenu.setSuperMenuno(null);
        }
        if (StringUtil.isEmpty((String)pMenu.getIcon())) {
            pMenu.setIcon(null);
        }
        if (StringUtil.isEmpty((String)pMenu.getUrl())) {
            pMenu.setUrl(null);
        }
        if (StringUtil.isNotEmpty((String)pMenu.getModuleNo()) && StringUtil.isEmpty((String)pMenu.getOp())) {
            pMenu.setOp("visit");
        }
        this.pMenuMapper.insert(pMenu);
    }

    @Transactional
    public void delete(String menuno) {
        List<PMenu> childs = this.list(menuno);
        for (PMenu m : childs) {
            this.delete(m.getMenuno());
        }
        PRoleModuleOpExample pRoleMenuOpExample = new PRoleModuleOpExample();
        pRoleMenuOpExample.createCriteria().andModuleNoEqualTo(menuno);
        this.pRoleMenuOpMapper.deleteByExample(pRoleMenuOpExample);
        this.pMenuMapper.deleteByPrimaryKey(menuno);
    }

    public void appentTo(String menuno, String parentMenuNo) {
        PMenu pMenu = new PMenu();
        pMenu.setMenuno(menuno);
        pMenu.setSuperMenuno(parentMenuNo);
        PMenuExample example = new PMenuExample();
        example.createCriteria().andSuperMenunoEqualTo(parentMenuNo).andMenunoNotEqualTo(menuno);
        Integer maxOrder = this.pMenuMapper.maxOrderByExample(example);
        if (maxOrder != null) {
            pMenu.setOrderno(maxOrder + 1);
        } else {
            pMenu.setOrderno(1);
        }
        this.pMenuMapper.updateColumnsByPrimaryKey(pMenu, "menuno", "superMenuno", "orderno");
    }

    @Transactional
    public void moveBefore(String menuno, String target) {
        PMenu current = new PMenu();
        current.setMenuno(menuno);
        PMenu targetMenu = this.pMenuMapper.selectByPrimaryKey(target);
        String parentNode = StringUtil.nvl((String)targetMenu.getSuperMenuno());
        current.setSuperMenuno(parentNode);
        PMenuExample example = new PMenuExample();
        if (parentNode != null) {
            example.createCriteria().andSuperMenunoEqualTo(parentNode).andMenunoNotEqualTo(menuno);
        } else {
            example.createCriteria().andSuperMenunoIsEmpty().andMenunoNotEqualTo(menuno);
        }
        example.setOrderByClause("ORDERNO ASC");
        List<PMenu> childs = this.pMenuMapper.selectByExample(example);
        int currentOrder = 0;
        for (PMenu m : childs) {
            if (m.getMenuno().equals(targetMenu.getMenuno())) {
                current.setOrderno(currentOrder);
                ++currentOrder;
            }
            m.setOrderno(currentOrder);
            ++currentOrder;
        }
        this.pMenuMapper.updateColumnsByPrimaryKey(current, "superMenuno", "orderno");
        this.batchHelper.getBatchExecuter(PMenuMapper.class).execute(childs, (IExecuteSingleAction)new IExecuteSingleAction<PMenuMapper, PMenu>(){

            public void execute(PMenuMapper dao, PMenu entity) {
                dao.updateColumnsByPrimaryKey(entity, "orderno");
            }
        });
    }

    @Transactional
    public void moveAfter(String menuno, String target) {
        PMenu current = new PMenu();
        current.setMenuno(menuno);
        PMenu targetMenu = this.pMenuMapper.selectByPrimaryKey(target);
        String parentNode = StringUtil.nvl((String)targetMenu.getSuperMenuno());
        current.setSuperMenuno(parentNode);
        PMenuExample example = new PMenuExample();
        if (parentNode != null) {
            example.createCriteria().andSuperMenunoEqualTo(parentNode).andMenunoNotEqualTo(menuno);
        } else {
            example.createCriteria().andSuperMenunoIsEmpty().andMenunoNotEqualTo(menuno);
        }
        example.setOrderByClause("ORDERNO ASC");
        List<PMenu> childs = this.pMenuMapper.selectByExample(example);
        int currentOrder = 0;
        for (PMenu m : childs) {
            m.setOrderno(currentOrder);
            if (m.getMenuno().equals(targetMenu.getMenuno())) {
                current.setOrderno(++currentOrder);
            }
            ++currentOrder;
        }
        this.pMenuMapper.updateColumnsByPrimaryKey(current, "superMenuno", "orderno");
        this.batchHelper.getBatchExecuter(PMenuMapper.class).execute(childs, (IExecuteSingleAction)new IExecuteSingleAction<PMenuMapper, PMenu>(){

            public void execute(PMenuMapper dao, PMenu entity) {
                dao.updateColumnsByPrimaryKey(entity, "orderno");
            }
        });
    }

    public void updateMenu(PMenu pMenu) {
        if (pMenu.getOrderno() == null) {
            pMenu.setOrderno(0);
        }
        if (StringUtil.isEmpty((String)pMenu.getSuperMenuno())) {
            pMenu.setSuperMenuno(null);
        }
        if (StringUtil.isEmpty((String)pMenu.getIcon())) {
            pMenu.setIcon(null);
        }
        if (StringUtil.isEmpty((String)pMenu.getUrl())) {
            pMenu.setUrl(null);
        }
        if (StringUtil.isNotEmpty((String)pMenu.getModuleNo()) && StringUtil.isEmpty((String)pMenu.getOp())) {
            pMenu.setOp("visit");
        }
        this.pMenuMapper.updateByPrimaryKey(pMenu);
    }
}

