/*
 * Decompiled with CFR 0.152.
 */
package com.help.service;

import com.help.LoginInfo;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.Convert;
import com.help.common.util.StringUtil;
import com.help.domain.DeptInfo;
import com.help.domain.OrgInfoBase;
import com.help.domain.UserInfo;
import com.help.service.ILoginService;
import com.help.service.PermissionService;
import com.help.service.UserConfigService;
import com.help.storage.IUserStorage;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginService
implements ILoginService {
    @Autowired
    IUserStorage iUserStorage;
    @Autowired
    PermissionService permissionService;
    @Autowired
    UserConfigService userConfigService;

    private LoginInfo getToken(UserInfo userInfo) {
        if (userInfo != null) {
            if (!"1".equalsIgnoreCase(userInfo.getState())) {
                throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "\u7528\u6237\u5df2\u505c\u7528");
            }
            LoginInfo loginInfo = new LoginInfo();
            loginInfo.setCurrentUser(userInfo);
            loginInfo.setUserId(userInfo.getUserNo());
            loginInfo.setLoginTime(new Date());
            List<OrgInfoBase> orgs = this.permissionService.listOrgs(userInfo.getUserNo());
            List<DeptInfo> depts = this.permissionService.listDepts(userInfo.getUserNo());
            String lastLoginTime = this.userConfigService.get(userInfo.getUserNo(), "LAST_LOGIN_TIME");
            if (StringUtil.isNotEmpty((String)lastLoginTime)) {
                try {
                    loginInfo.setLastLoginTime(Convert.toDate((String)lastLoginTime, (String)"yyyy-MM-dd HH:mm:ss"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.userConfigService.save(userInfo.getUserNo(), "LAST_LOGIN_TIME", Convert.toString((Date)loginInfo.getLoginTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            DeptInfo loginDept = null;
            String lastDept = this.userConfigService.get(userInfo.getUserNo(), "LAST_LOGIN_DEPT");
            if (StringUtil.isNotEmpty((String)lastDept)) {
                loginDept = depts.stream().filter(p -> p.getDeptNo().equalsIgnoreCase(lastDept)).findFirst().orElse(null);
            }
            if (StringUtil.isEmpty((String)lastLoginTime) && loginDept == null && depts.size() > 0) {
                loginDept = depts.get(0);
            }
            if (loginDept != null) {
                loginInfo.setLoginDept(loginDept.getDeptNo());
                if (!loginDept.getDeptNo().equalsIgnoreCase(lastDept)) {
                    this.userConfigService.save(userInfo.getUserNo(), "LAST_LOGIN_DEPT", loginDept.getDeptNo());
                }
            } else if (StringUtil.isNotEmpty((String)lastDept)) {
                this.userConfigService.delete(userInfo.getUserNo(), "LAST_LOGIN_DEPT");
            }
            OrgInfoBase loginOrg = null;
            String lastOrg = this.userConfigService.get(userInfo.getUserNo(), "LAST_LOGIN_ORG");
            if (StringUtil.isNotEmpty((String)lastOrg)) {
                loginOrg = orgs.stream().filter(p -> p.getOrgNo().equalsIgnoreCase(lastOrg)).findFirst().orElse(null);
            }
            if (StringUtil.isEmpty((String)lastLoginTime) && loginOrg == null && orgs.size() > 0) {
                loginOrg = orgs.get(0);
            }
            if (loginOrg != null) {
                loginInfo.setLoginOrg(loginOrg.getOrgNo());
                if (!loginOrg.getOrgNo().equalsIgnoreCase(lastOrg)) {
                    this.userConfigService.save(userInfo.getUserNo(), "LAST_LOGIN_ORG", loginOrg.getOrgNo());
                }
            } else if (StringUtil.isNotEmpty((String)lastOrg)) {
                this.userConfigService.delete(userInfo.getUserNo(), "LAST_LOGIN_ORG");
            }
            List<String> roles = this.permissionService.listRoleNos(userInfo.getUserNo(), loginInfo.getLoginOrg(), loginInfo.getLoginDept(), false);
            loginInfo.setLoginRoles(roles);
            if (StringUtil.isNotEmpty((String)userInfo.getLegalPersonality()) && !roles.contains("admin")) {
                loginInfo.setLegalPersonality(userInfo.getLegalPersonality());
            }
            return loginInfo;
        }
        throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
    }

    public LoginInfo getToken(String userNo, String password) {
        UserInfo userInfo = ((IUserStorage)this.iUserStorage.getLegalProxy(null)).get(userNo, password);
        if (userInfo != null) {
            return this.getToken(userInfo);
        }
        throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
    }

    public LoginInfo getToken(String userNo) {
        UserInfo userInfo = ((IUserStorage)this.iUserStorage.getLegalProxy(null)).get(userNo);
        if (userInfo != null) {
            return this.getToken(userInfo);
        }
        throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728");
    }
}

