/*
 * Decompiled with CFR 0.152.
 */
package com.help.service;

import com.help.common.exception.UnifyException;
import com.help.common.util.MimeUtil;
import com.help.common.util.StringUtil;
import com.help.dao.PFileMapper;
import com.help.domain.FileInfo;
import com.help.domain.FileInfoBase;
import com.help.domain.PFile;
import com.help.domain.PFileExample;
import com.help.service.IFileService;
import com.help.storage.IFileStorage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileService
implements IFileService {
    @Autowired
    PFileMapper pFileMapper;
    @Autowired
    IFileStorage iFileStorage;

    public String saveFile(MultipartFile f, String inputUser) {
        String fileName = f.getOriginalFilename();
        if (StringUtil.isNotEmpty((String)fileName)) {
            FileInfoBase file = new FileInfoBase();
            file.setOriginalName(fileName);
            file.setInputUser(inputUser);
            file.setFileMime(f.getContentType());
            try {
                return this.saveFile(file, f.getInputStream());
            }
            catch (UnifyException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UnifyException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:[" + e.getMessage() + "]");
            }
        }
        return null;
    }

    public String saveFile(FileInfoBase base, byte[] data) {
        if (StringUtil.isEmpty((String)base.getFileMime())) {
            base.setFileMime(MimeUtil.getMimetype((String)base.getOriginalName()));
        }
        return this.saveFile(base, new ByteArrayInputStream(data));
    }

    public String saveFile(FileInfoBase base, InputStream inputStream) {
        String id = this.iFileStorage.save(inputStream, base.getOriginalName());
        PFile file = new PFile();
        file.setInputUser(base.getInputUser());
        file.setOriginalName(base.getOriginalName());
        file.setFileMime(base.getFileMime());
        if (StringUtil.isEmpty((String)base.getFileMime())) {
            file.setFileMime(MimeUtil.getMimetype((String)base.getOriginalName()));
        }
        file.setGmtCreate(new Date());
        file.setFileSize(this.iFileStorage.getSize(id));
        file.setFileId(id);
        this.pFileMapper.insert(file);
        return id;
    }

    public void deleteFile(String fileId) {
        this.pFileMapper.deleteByPrimaryKey(fileId);
        this.iFileStorage.delete(fileId);
    }

    public FileInfo getInfo(String fileId) {
        return this.transform(this.pFileMapper.selectByPrimaryKey(fileId));
    }

    public Map<String, FileInfo> getInfos(String ... fileIds) {
        if (fileIds == null || fileIds.length == 0) {
            return new HashMap<String, FileInfo>();
        }
        PFileExample example = new PFileExample();
        example.createCriteria().andFileIdIn((List)Arrays.asList(fileIds));
        List<PFile> files = this.pFileMapper.selectByExample(example);
        HashMap<String, FileInfo> map = new HashMap<String, FileInfo>();
        for (String f : fileIds) {
            map.put(f, files.stream().filter(p -> p.getFileId().equalsIgnoreCase(f)).map(p -> this.transform((PFile)p)).findAny().orElse(null));
        }
        return map;
    }

    public List<FileInfo> listInfo(String ... fileIds) {
        if (fileIds != null && fileIds.length > 0) {
            PFileExample example = new PFileExample();
            example.createCriteria().andFileIdIn((List)Arrays.asList(fileIds));
            return this.pFileMapper.selectByExample(example).stream().map(p -> this.transform((PFile)p)).collect(Collectors.toList());
        }
        return new ArrayList<FileInfo>();
    }

    public byte[] getFile(String fileId) {
        return this.iFileStorage.get(fileId);
    }

    public InputStream getFileStream(String fileId) {
        return this.iFileStorage.getInputStream(fileId);
    }

    public FileInfo transform(PFile file) {
        if (file == null) {
            return null;
        }
        FileInfo info = new FileInfo();
        info.setFileSize(file.getFileSize());
        info.setGmtCreate(file.getGmtCreate());
        info.setFileMime(file.getFileMime());
        info.setFileId(file.getFileId());
        info.setInputUser(file.getInputUser());
        info.setOriginalName(file.getOriginalName());
        return info;
    }
}

