/*
 * Decompiled with CFR 0.152.
 */
package com.help.service;

import com.help.common.ICacheable;
import com.help.constraint.IDicExtension;
import com.help.constraint.ITreeDicExtension;
import com.help.domain.DicItem;
import com.help.domain.TreeDicItem;
import com.help.storage.IDicStorage;
import com.help.storage.ITreeDicStorage;
import java.util.ArrayList;
import java.util.List;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DictionaryService
implements ICacheable {
    @Autowired(required=false)
    private List<IDicExtension> iDicExtensions;
    @Autowired(required=false)
    private List<ITreeDicExtension> iTreeDicExtensions;
    @Autowired(required=false)
    private IDicStorage iDicStorage;
    @Autowired(required=false)
    private ITreeDicStorage iTreeDicStorage;
    @Autowired(required=false)
    CacheManager cacheManager;

    public List<DicItem> list(String dicType) {
        IDicExtension iDicExtension;
        if (this.iDicExtensions != null && (iDicExtension = (IDicExtension)this.iDicExtensions.stream().filter(p -> p.getDicType().equalsIgnoreCase(dicType)).findFirst().orElse(null)) != null) {
            if (iDicExtension.cacheable()) {
                return ((DictionaryService)AopContext.currentProxy()).listExtensionCache(dicType);
            }
            return iDicExtension.list();
        }
        return ((DictionaryService)AopContext.currentProxy()).listBase(dicType);
    }

    @Cacheable(value={"dictionary"})
    public List<DicItem> listExtensionCache(String dicType) {
        IDicExtension iDicExtension = this.iDicExtensions.stream().filter(p -> p.getDicType().equalsIgnoreCase(dicType)).findFirst().orElse(null);
        if (iDicExtension != null) {
            return iDicExtension.list();
        }
        return new ArrayList<DicItem>();
    }

    @Cacheable(value={"dictionary"})
    public List<DicItem> listBase(String dicType) {
        if (this.iDicStorage != null) {
            return this.iDicStorage.list(dicType);
        }
        return new ArrayList<DicItem>();
    }

    public List<TreeDicItem> listTree(String dicType) {
        ITreeDicExtension iTreeDicExtension;
        if (this.iTreeDicExtensions != null && (iTreeDicExtension = (ITreeDicExtension)this.iTreeDicExtensions.stream().filter(p -> p.getDicType().equalsIgnoreCase(dicType)).findFirst().orElse(null)) != null) {
            if (iTreeDicExtension.cacheable()) {
                return ((DictionaryService)AopContext.currentProxy()).listTreeExtensionCache(dicType);
            }
            return iTreeDicExtension.list();
        }
        return ((DictionaryService)AopContext.currentProxy()).listTreeBase(dicType);
    }

    @Cacheable(value={"dictionary"})
    public List<TreeDicItem> listTreeBase(String dicType) {
        if (this.iTreeDicStorage != null) {
            return this.iTreeDicStorage.list(dicType);
        }
        return new ArrayList<TreeDicItem>();
    }

    @Cacheable(value={"dictionary"})
    public List<TreeDicItem> listTreeExtensionCache(String dicType) {
        ITreeDicExtension iTreeDicExtension = this.iTreeDicExtensions.stream().filter(p -> p.getDicType().equalsIgnoreCase(dicType)).findFirst().orElse(null);
        if (iTreeDicExtension != null) {
            return iTreeDicExtension.list();
        }
        return new ArrayList<TreeDicItem>();
    }

    public void refresh() {
        if (this.cacheManager != null) {
            this.cacheManager.getCache("dictionary").clear();
        }
    }
}

