/*
 * Decompiled with CFR 0.152.
 */
package com.help.plugins;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.common.util.StringUtil;
import com.help.config.HelpManageConfig;
import com.help.constraint.IHelpSystemComponent;
import com.help.constraint.ITreeDicExtension;
import com.help.domain.TreeDicItem;
import com.help.storage.IOrgStorage;
import com.help.storage.legal.ILegalableStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class OrgTreeDicExtension
implements ITreeDicExtension,
IHelpSystemComponent {
    @Autowired(required=false)
    IOrgStorage iOrgStorage;
    @Autowired(required=false)
    ITokenContext<LoginInfo> iTokenContext;
    @Autowired
    HelpManageConfig helpManageConfig;

    public String getName() {
        return "\u673a\u6784\u6811\u578b\u5b57\u5178\u6269\u5c55\u670d\u52a1(\u7f13\u5b58)";
    }

    public String getDicType() {
        return "ORG";
    }

    public List<TreeDicItem> list() {
        LoginInfo loginInfo;
        if (this.helpManageConfig.isMultiLegalEnable() && this.iTokenContext != null && (loginInfo = (LoginInfo)this.iTokenContext.getCurrentToken()) != null) {
            return ((OrgTreeDicExtension)AopContext.currentProxy()).listByLegal(loginInfo.getLegalPersonality(), false);
        }
        return ((OrgTreeDicExtension)AopContext.currentProxy()).listByLegal(null, false);
    }

    @Cacheable(value={"dictionary"})
    public List<TreeDicItem> listByLegal(String legal, boolean limitIfEmpty) {
        if (this.iOrgStorage != null) {
            if ((StringUtil.isNotEmpty((String)legal) || limitIfEmpty) && this.iOrgStorage instanceof ILegalableStorage) {
                return ((IOrgStorage)this.iOrgStorage.getLegalProxy(legal)).listAll().stream().map(p -> new TreeDicItem(p.getOrgNo(), p.getOrgShortName(), p.getParentNo())).collect(Collectors.toList());
            }
            return ((IOrgStorage)this.iOrgStorage.getLegalProxy(null)).listAll().stream().map(p -> new TreeDicItem(p.getOrgNo(), p.getOrgShortName(), p.getParentNo())).collect(Collectors.toList());
        }
        return new ArrayList<TreeDicItem>();
    }

    public boolean cacheable() {
        return false;
    }
}

