/*
 * Decompiled with CFR 0.152.
 */
package com.help.plugins;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.common.util.StringUtil;
import com.help.config.HelpManageConfig;
import com.help.constraint.IDicExtension;
import com.help.constraint.IHelpSystemComponent;
import com.help.domain.DicItem;
import com.help.storage.IDeptStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class DeptDicExtension
implements IDicExtension,
IHelpSystemComponent {
    @Autowired(required=false)
    IDeptStorage iDeptStorage;
    @Autowired
    HelpManageConfig helpManageConfig;
    @Autowired(required=false)
    ITokenContext<LoginInfo> iTokenContext;

    public String getDicType() {
        return "DEPT";
    }

    public List<DicItem> list() {
        LoginInfo loginInfo;
        if (this.helpManageConfig.isMultiLegalEnable() && this.iTokenContext != null && (loginInfo = (LoginInfo)this.iTokenContext.getCurrentToken()) != null) {
            return ((DeptDicExtension)AopContext.currentProxy()).listByLegal(loginInfo.getLegalPersonality(), false);
        }
        return ((DeptDicExtension)AopContext.currentProxy()).listByLegal(null, false);
    }

    @Cacheable(value={"dictionary"})
    public List<DicItem> listByLegal(String legal, boolean limitIfEmpty) {
        if (this.iDeptStorage != null) {
            if (StringUtil.isNotEmpty((String)legal) || limitIfEmpty) {
                return ((IDeptStorage)this.iDeptStorage.getLegalProxy(legal)).list().stream().map(p -> new DicItem(p.getDeptNo(), p.getDeptName(), this.getDicType())).collect(Collectors.toList());
            }
            return ((IDeptStorage)this.iDeptStorage.getLegalProxy(null)).list().stream().map(p -> new DicItem(p.getDeptNo(), p.getDeptName(), this.getDicType())).collect(Collectors.toList());
        }
        return new ArrayList<DicItem>();
    }

    public boolean cacheable() {
        return false;
    }

    public String getName() {
        return "\u90e8\u95e8\u5b57\u5178\u6269\u5c55\u670d\u52a1(\u7f13\u5b58)";
    }
}

