/*
 * Decompiled with CFR 0.152.
 */
package com.help.common;

import com.help.common.tuple.Tuple2;
import com.help.common.util.StringUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Random;

public class HelpManageUtil {
    private HelpManageUtil() {
    }

    public static boolean strongCipherValid(String password) {
        if (StringUtil.isNotEmpty((String)password) && password.length() >= 8) {
            StringBuilder sample = new StringBuilder("abcdefghijklmnopqrstuvwxyz01234567890`1234567890-=qwertyuiop[]\\asdfghjkl;'zxcvbnm,./");
            if (sample.indexOf(password) >= 0) {
                return false;
            }
            if (sample.reverse().indexOf(password) >= 0) {
                return false;
            }
            int num = 0;
            int lower = 0;
            int upper = 0;
            int other = 0;
            for (int i = 0; i < password.length(); ++i) {
                char c = password.charAt(i);
                if (c >= '0' && c <= '9') {
                    num = 1;
                    continue;
                }
                if (c >= 'a' && c <= 'z') {
                    lower = 1;
                    continue;
                }
                if (c >= 'A' && c <= 'Z') {
                    upper = 1;
                    continue;
                }
                if (!(c >= '!' && c <= '/' || c >= ':' && c <= '@' || c >= '[' && c <= '`') && (c < '{' || c > '~')) continue;
                other = 1;
            }
            return num + lower + upper + other >= 3;
        }
        return false;
    }

    public static Tuple2<String, BufferedImage> getValidCodeImage(int count) {
        int x = 60 * count;
        int y = 100;
        int fontSize = 70;
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        Color bgColor = new Color(255, 255, 255);
        String[] fontsName = new String[]{"\u5b8b\u4f53", "\u534e\u6587\u6977\u4f53", "\u9ed1\u4f53", "\u534e\u6587\u65b0\u9b4f", "\u534e\u6587\u96b6\u4e66", "\u5fae\u8f6f\u96c5\u9ed1", "\u6977\u4f53_GB2312"};
        String codes = "23456789abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ";
        BufferedImage bi = new BufferedImage(x, y, 1);
        Graphics2D pen = (Graphics2D)bi.getGraphics();
        pen.setColor(bgColor);
        pen.fillRect(0, 0, x, y);
        pen.shear(-0.1, 0.2);
        for (int i = 0; i < count; ++i) {
            int red = random.nextInt(150);
            int green = random.nextInt(150);
            int blue = random.nextInt(150);
            Color color = new Color(red, green, blue);
            int index = random.nextInt(fontsName.length);
            String font = fontsName[index];
            int style = random.nextInt(4);
            pen.setColor(color);
            pen.setFont(new Font(font, style, fontSize));
            index = random.nextInt(codes.length());
            String s = String.valueOf(codes.charAt(index));
            sb.append(s);
            if (i % 2 == 0) {
                pen.shear(0.2, -0.4);
                pen.drawString(s, i * 45, 70 + i * 10);
                continue;
            }
            pen.shear(-0.2, 0.4);
            pen.drawString(s, i * 45, 70 - i * 10);
        }
        int lineNumber = 5;
        pen = (Graphics2D)bi.getGraphics();
        pen.setColor(Color.RED);
        pen.setStroke(new BasicStroke(1.5f, 1, 0));
        for (int i = 0; i < lineNumber; ++i) {
            int x1 = random.nextInt(x / 10);
            int y1 = random.nextInt(y);
            int x2 = random.nextInt(x * 10);
            int y2 = random.nextInt(y);
            pen.drawLine(x1, y1, x2, y2);
        }
        return new Tuple2((Object)sb.toString(), (Object)bi);
    }
}

