/*
 * Decompiled with CFR 0.152.
 */
package com.help;

import com.help.common.IInvocationData;
import com.help.common.UnifyPageData;
import com.help.common.exception.UnifyException;
import com.help.common.util.BeanConvert;
import com.help.common.util.Convert;
import com.help.common.util.StringUtil;
import com.help.common.util.intf.IAction3;
import com.help.common.util.reflect.ReflectUtil;
import com.help.constraint.IHelpDomain;
import com.help.constraint.IHelpExample;
import com.help.constraint.ISearchable;
import com.help.domain.TreeDicItem;
import com.help.service.DictionaryService;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Transcoder
implements IInvocationData {
    private Map<String, ISearchable<?, IHelpExample<?, ?>>> services = null;
    private Map<String, Class<?>> examples = null;
    private DictionaryService dictionaryService;
    private Object entity;
    private List<Map<String, Object>> data;
    private boolean singleMode;
    private boolean replaceMode;

    protected Transcoder(Object entity, boolean replaceMode) {
        this.replaceMode = replaceMode;
        this.entity = entity;
        if (entity != null) {
            if (entity instanceof UnifyPageData) {
                this.data = BeanConvert.toMapList((Iterable)((UnifyPageData)entity).getList(), (String[])new String[0]);
            } else if (entity instanceof Iterable) {
                this.data = BeanConvert.toMapList((Iterable)((Iterable)entity), (String[])new String[0]);
            } else if (entity.getClass().isArray()) {
                this.data = BeanConvert.toMapList((Object)entity, (String[])new String[0]);
            } else {
                this.singleMode = true;
                this.data = new LinkedList<Map<String, Object>>();
                this.data.add(BeanConvert.toMap((Object)entity, (String[])new String[0]));
            }
        }
    }

    public void init(Map<String, ISearchable<?, IHelpExample<?, ?>>> services, Map<String, Class<?>> examples, DictionaryService dictionaryService) {
        this.services = services;
        this.examples = examples;
        this.dictionaryService = dictionaryService;
    }

    public Transcoder setReplaceMode(boolean replaceMode) {
        this.replaceMode = replaceMode;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Transcoder transcode(String field, Iterable<?> list, String matchField, String displayField, String transcodedFieldName) {
        if (this.data != null && this.data.size() > 0 && list != null) {
            if (!this.data.get(0).containsKey(field)) throw new UnifyException("\u5bf9\u8c61[" + this.entity + "]\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5[" + field + "]");
            Iterator<?> listIterator = list.iterator();
            if (listIterator.hasNext()) {
                Object l = listIterator.next();
                if (l instanceof Map) {
                    block2: for (Map<String, Object> map : this.data) {
                        Object value = map.get(field);
                        if (value == null) continue;
                        for (Object e : list) {
                            Map obj = (Map)e;
                            Object matchValue = obj.get(matchField);
                            if (matchValue == null || !matchValue.toString().equals(value.toString())) continue;
                            if (StringUtil.isNotEmpty((String)transcodedFieldName)) {
                                map.put(transcodedFieldName, obj.get(displayField));
                                continue block2;
                            }
                            if (this.replaceMode) {
                                map.put(field, obj.get(displayField));
                                continue block2;
                            }
                            map.put(field + "_displayname", obj.get(displayField));
                            continue block2;
                        }
                    }
                } else {
                    Field mField = ReflectUtil.getField(l.getClass(), (String)matchField);
                    if (mField == null) throw new UnifyException("\u5bf9\u8c61[" + l + "]\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5[" + matchField + "]");
                    Field nField = ReflectUtil.getField(l.getClass(), (String)displayField);
                    if (nField == null) throw new UnifyException("\u5bf9\u8c61[" + l + "]\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5[" + displayField + "]");
                    if (!mField.isAccessible()) {
                        mField.setAccessible(true);
                    }
                    if (!nField.isAccessible()) {
                        nField.setAccessible(true);
                    }
                    block4: for (Map<String, Object> map : this.data) {
                        Object value = map.get(field);
                        if (value == null) continue;
                        for (Object obj : list) {
                            try {
                                Object matchValue = mField.get(obj);
                                if (matchValue == null || !matchValue.toString().equals(value.toString())) continue;
                                if (StringUtil.isNotEmpty((String)transcodedFieldName)) {
                                    map.put(transcodedFieldName, nField.get(obj));
                                    continue block4;
                                }
                                if (this.replaceMode) {
                                    map.put(field, nField.get(obj));
                                    continue block4;
                                }
                                map.put(field + "_displayname", nField.get(obj));
                                continue block4;
                            }
                            catch (Exception e) {
                                throw new UnifyException("\u672a\u77e5\u539f\u56e0\u5bfc\u81f4\u7684\u8f6c\u7801\u5931\u8d25", (Throwable)e);
                            }
                        }
                    }
                }
            }
        }
        for (Map<String, Object> e : this.data) {
            if (StringUtil.isNotEmpty((String)transcodedFieldName)) {
                if (e.containsKey(transcodedFieldName)) continue;
                e.put(transcodedFieldName, null);
                continue;
            }
            if (this.replaceMode && !e.containsKey(field)) {
                e.put(field, null);
                continue;
            }
            if (this.replaceMode || e.containsKey(field + "_displayname")) continue;
            e.put(field + "_displayname", null);
        }
        return this;
    }

    public Transcoder transcode(String field, Iterable<?> list, String matchField, String displayField) {
        return this.transcode(field, list, matchField, displayField, null);
    }

    public <T> Transcoder transcode(String field, T[] arr, String matchField, String displayField, String transcodedFieldName) {
        return this.transcode(field, Arrays.asList(arr), matchField, displayField, transcodedFieldName);
    }

    public <T> Transcoder transcode(String field, T[] arr, String matchField, String displayField) {
        return this.transcode(field, Arrays.asList(arr), matchField, displayField, null);
    }

    public Transcoder transcode(String field, String dictype, String transcodedFieldName) {
        return this.transcode(field, dictype, transcodedFieldName, false);
    }

    public Transcoder transcode(String field, String dictype) {
        return this.transcode(field, dictype, null, false);
    }

    public Transcoder transcode(String field, String dictype, boolean withParent) {
        return this.transcode(field, dictype, null, withParent);
    }

    public Transcoder transcode(String field, String dictype, String transcodedFieldName, boolean withParent) {
        List<Object> dics = null;
        dics = this.dictionaryService != null ? this.dictionaryService.list(dictype) : new ArrayList();
        if (dics.size() > 0) {
            return this.transcode(field, dics, "code", "text", transcodedFieldName);
        }
        List<Object> treeDicItems = null;
        treeDicItems = this.dictionaryService != null ? this.dictionaryService.listTree(dictype) : new ArrayList();
        if (!withParent) {
            return this.transcode(field, treeDicItems, "code", "text", transcodedFieldName);
        }
        ArrayList<TreeDicItem> result = new ArrayList<TreeDicItem>();
        IAction3<TreeDicItem, List<TreeDicItem>, List<TreeDicItem>> fetchChild = new IAction3<TreeDicItem, List<TreeDicItem>, List<TreeDicItem>>(){

            public void execute(TreeDicItem parent, List<TreeDicItem> all, List<TreeDicItem> result) {
                for (TreeDicItem c : all) {
                    if (!StringUtil.isNotEmpty((String)c.getParent()) || !c.getParent().equals(parent.getCode())) continue;
                    TreeDicItem n = new TreeDicItem(c.getCode(), parent.getText() + "-" + c.getText(), c.getParent());
                    result.add(n);
                    this.execute(n, all, result);
                }
            }
        };
        for (TreeDicItem treeDicItem : treeDicItems) {
            if (!StringUtil.isEmpty((String)treeDicItem.getParent())) continue;
            TreeDicItem n = new TreeDicItem(treeDicItem.getCode(), treeDicItem.getText(), null);
            result.add(n);
            fetchChild.execute((Object)n, treeDicItems, result);
        }
        return this.transcode(field, result, "code", "text", transcodedFieldName);
    }

    public <T extends IHelpDomain> Transcoder transcode(String field, Class<T> clazzOfMatch, String matchField, String displayField, String transcodedFieldName) {
        List matchList = null;
        ArrayList<Object> fields = new ArrayList<Object>();
        if (this.data != null && this.data.size() > 0) {
            for (Map<String, Object> entity : this.data) {
                if (!StringUtil.isNotEmpty((Object)entity.get(field)) || fields.contains(entity.get(field))) continue;
                fields.add(entity.get(field));
            }
        }
        if (fields.size() > 0) {
            ISearchable<?, IHelpExample<?, ?>> service = this.services.get(clazzOfMatch.getName());
            Class<?> exampleClass = this.examples.get(clazzOfMatch.getName());
            if (service != null && exampleClass != null) {
                try {
                    IHelpExample example = (IHelpExample)exampleClass.newInstance();
                    Object criteria = example.createCriteria();
                    Method andMatchFieldIn = criteria.getClass().getMethod("and" + matchField.substring(0, 1).toUpperCase() + matchField.substring(1) + "In", List.class);
                    ArrayList<Object> list = new ArrayList<Object>();
                    Field f = ReflectUtil.getField(clazzOfMatch, (String)matchField);
                    if (f.getType().equals(String.class)) {
                        for (Object e : fields) {
                            list.add(e.toString());
                        }
                    } else if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                        for (Object e : fields) {
                            list.add(Convert.toInt(e));
                        }
                    } else if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                        for (Object e : fields) {
                            list.add(Convert.toLong(e));
                        }
                    }
                    ReflectUtil.invoke((Object)criteria, (Method)andMatchFieldIn, (Object[])new Object[]{list});
                    String[] columns = new String[]{matchField, displayField};
                    matchList = service.list(example, columns);
                }
                catch (Exception e) {
                    throw new UnifyException("\u901a\u8fc7\u7c7b[" + clazzOfMatch.getName() + "]\u6784\u9020\u8f6c\u7801\u5668\u5931\u8d25,\u65e0\u6cd5\u6784\u9020[" + clazzOfMatch.getName() + "Example]\u7c7b\uff0c\u6216\u8005\u627e\u4e0d\u5230[" + matchField + "]\u5b57\u6bb5", (Throwable)e);
                }
            }
        }
        return this.transcode(field, matchList, matchField, displayField, transcodedFieldName);
    }

    public <T extends IHelpDomain> Transcoder transcode(String field, Class<T> clazzOfMatch, String matchField, String displayField) {
        return this.transcode(field, clazzOfMatch, matchField, displayField, null);
    }

    public Object getResult() {
        if (this.entity == null) {
            return null;
        }
        if (this.entity instanceof UnifyPageData) {
            UnifyPageData unifyPageData = (UnifyPageData)this.entity;
            return new UnifyPageData(this.data, unifyPageData.getPageIndex(), unifyPageData.getPageSize(), unifyPageData.getTotalSize());
        }
        if (this.data == null) {
            return null;
        }
        if (this.singleMode) {
            return this.data.get(0);
        }
        return this.data;
    }
}

