/*
 * Decompiled with CFR 0.152.
 */
package com.help;

import com.help.annotation.UnifyAuthorization;
import com.help.common.util.StringUtil;
import com.help.common.util.reflect.ReflectUtil;
import com.help.config.HelpManageConfig;
import com.help.constraint.IModuleOperationRegister;
import com.help.domain.permission.Module;
import com.help.domain.permission.Operation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;

@Component
public class ModuleAnalasys {
    @Autowired
    ApplicationContext applicationContext;
    private Map<String, Module> modules;
    private List<Operation> grantToAll;
    @Autowired
    private HelpManageConfig helpManageConfig;

    @PostConstruct
    public void init() {
        ArrayList ctrls = new ArrayList();
        ctrls.addAll(this.applicationContext.getBeansWithAnnotation(Controller.class).values());
        ctrls.addAll(this.applicationContext.getBeansWithAnnotation(RestController.class).values());
        HashMap<String, Module> modules = new HashMap<String, Module>();
        ArrayList<Operation> grantToAll = new ArrayList<Operation>();
        for (Object o : ctrls) {
            Class clz = AopUtils.getTargetClass(o);
            UnifyAuthorization classAnno = clz.getAnnotation(UnifyAuthorization.class);
            List mtds = ReflectUtil.getAllMethods((Class)clz);
            Iterator iterator = mtds.iterator();
            while (iterator.hasNext()) {
                Method m = (Method)iterator.next();
                UnifyAuthorization anno = m.getAnnotation(UnifyAuthorization.class);
                if (classAnno == null && anno == null) continue;
                String module = null;
                String op = null;
                String system = null;
                String moduleName = null;
                String opName = null;
                boolean all = false;
                if (anno != null) {
                    module = anno.module();
                    moduleName = anno.moduleName();
                    op = anno.op();
                    opName = anno.opName();
                    system = anno.system();
                    all = anno.grantToAll();
                }
                if (classAnno != null) {
                    if (StringUtil.isEmpty((String)module)) {
                        module = classAnno.module();
                        moduleName = classAnno.moduleName();
                    }
                    if (StringUtil.isEmpty(op)) {
                        op = classAnno.op();
                        opName = classAnno.opName();
                    }
                    if (StringUtil.isEmpty(system)) {
                        system = classAnno.system();
                    }
                    if (anno == null) {
                        all = classAnno.grantToAll();
                    }
                }
                if (!StringUtil.isNotEmpty((String)module)) continue;
                Module md = (Module)modules.get(module);
                if (md == null) {
                    md = new Module();
                    md.setModule(module);
                    md.setName(StringUtil.nvl((String)moduleName, (String)module));
                    md.setSystem("1".equalsIgnoreCase(system) ? "1" : "0");
                    modules.put(module, md);
                }
                if (!StringUtil.isNotEmpty((String)op)) continue;
                Operation operation = new Operation();
                operation.setModule(module);
                operation.setOp(op);
                operation.setName(StringUtil.nvl((String)opName, (String)this.transOp(op)));
                md.addOperation(operation);
                if (!all && !this.helpManageConfig.isDisablePermission()) continue;
                operation.setReadonly(true);
                grantToAll.add(operation);
            }
        }
        Collection registers = this.applicationContext.getBeansOfType(IModuleOperationRegister.class).values();
        for (IModuleOperationRegister register : registers) {
            List list = register.register();
            for (Module m : list) {
                Module md = (Module)modules.get(m.getModule());
                if (md == null) {
                    md = m;
                    modules.put(m.getModule(), m);
                }
                md.getOperations().addAll(m.getOperations().stream().map(p -> {
                    if (this.helpManageConfig.isDisablePermission()) {
                        p.setReadonly(true);
                    }
                    return p;
                }).collect(Collectors.toList()));
            }
        }
        for (Module m : modules.values()) {
            Iterator it = m.getOperations().iterator();
            Operation find = null;
            while (it.hasNext()) {
                Operation op = (Operation)it.next();
                if (!op.getOp().equalsIgnoreCase("visit")) continue;
                it.remove();
                find = op;
            }
            if (find == null) continue;
            m.getOperations().add(0, find);
        }
        this.modules = modules;
        this.grantToAll = grantToAll;
    }

    public List<Operation> listOps() {
        ArrayList<Operation> ops = new ArrayList<Operation>();
        for (Module m : this.modules.values()) {
            ops.addAll(m.getOperations());
        }
        return ops;
    }

    public List<Module> list() {
        return new ArrayList<Module>(this.modules.values());
    }

    public List<Operation> listSystemOps() {
        ArrayList<Operation> ops = new ArrayList<Operation>();
        this.listSystem().stream().forEach(p -> ops.addAll(p.getOperations()));
        return ops;
    }

    public List<Module> listSystem() {
        return this.modules.values().stream().filter(p -> "1".equalsIgnoreCase(p.getSystem())).collect(Collectors.toList());
    }

    public List<Operation> listGrantToAll() {
        return this.grantToAll;
    }

    public Module get(String module) {
        return this.modules.get(module);
    }

    private String transOp(String op) {
        if ("add".equalsIgnoreCase(op)) {
            return "\u65b0\u589e";
        }
        if ("update".equalsIgnoreCase(op)) {
            return "\u4fee\u6539";
        }
        if ("delete".equalsIgnoreCase(op)) {
            return "\u5220\u9664";
        }
        if ("detail".equalsIgnoreCase(op)) {
            return "\u8be6\u60c5";
        }
        if ("visit".equalsIgnoreCase(op)) {
            return "\u57fa\u672c\u67e5\u8be2";
        }
        return op;
    }
}

