/*
 * Decompiled with CFR 0.152.
 */
package com.help.concurrent;

import com.help.common.concurrent.IHelpLocker;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.StringUtil;
import com.help.constraint.IHelpSystemComponent;
import com.help.dao.PLockMapper;
import com.help.domain.PLock;
import com.help.domain.PLockExample;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;

public class HelpDbLocker
implements IHelpLocker,
IHelpSystemComponent {
    @Autowired
    PLockMapper pLockMapper;
    private int interval = 500;
    ThreadLocal<Map<String, String>> keyMapThreadLocal = new ThreadLocal();

    private Map<String, String> getKeyMap() {
        Map<String, String> map = this.keyMapThreadLocal.get();
        if (map == null) {
            map = new HashMap<String, String>();
            this.keyMapThreadLocal.set(map);
        }
        return map;
    }

    public void lock(String name, long leaseTime) throws InterruptedException {
        while (!Thread.currentThread().isInterrupted()) {
            boolean succ = this.tryLock(name, leaseTime);
            if (succ) {
                return;
            }
            Thread.sleep(this.interval);
        }
        throw new InterruptedException();
    }

    public boolean tryLock(String name, long leaseTimeMs) {
        PLockExample example;
        String key = this.getKeyMap().get(name);
        if (StringUtil.isNotEmpty((String)key)) {
            example = new PLockExample();
            example.createCriteria().andLockNameEqualTo(name).andLockKeyEqualTo(key);
            int count = -1;
            try {
                count = this.pLockMapper.increaseByExample(example, new Date(new Date().getTime() + leaseTimeMs));
            }
            catch (Exception e) {
                throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u83b7\u53d6\u9501[" + name + "]\u5931\u8d25", (Throwable)e);
            }
            if (count > 0) {
                return true;
            }
            this.getKeyMap().remove(name);
        }
        example = new PLockExample();
        example.createCriteria().andLockNameEqualTo(name).andLimitTimeLessThan(new Date());
        try {
            this.pLockMapper.deleteByExample(example);
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u83b7\u53d6\u9501[" + name + "]\u5931\u8d25", (Throwable)e);
        }
        PLock pLock = new PLock();
        pLock.setCreateTime(new Date());
        pLock.setLimitTime(new Date(pLock.getCreateTime().getTime() + leaseTimeMs));
        pLock.setLockCount(1);
        pLock.setLockKey(UUID.randomUUID().toString());
        pLock.setLockName(name);
        try {
            this.pLockMapper.insert(pLock);
            this.getKeyMap().put(name, pLock.getLockKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean tryLock(String name, long waitMs, long leaseTimeMs) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - waitMs < start) {
            if (!Thread.currentThread().isInterrupted()) {
                boolean succ = this.tryLock(name, leaseTimeMs);
                if (succ) {
                    return true;
                }
                Thread.sleep(this.interval);
                continue;
            }
            throw new InterruptedException();
        }
        return false;
    }

    public void unlock(String name) {
        String key = this.getKeyMap().get(name);
        if (StringUtil.isNotEmpty((String)key)) {
            PLockExample reduce = new PLockExample();
            reduce.createCriteria().andLockNameEqualTo(name).andLockKeyEqualTo(key);
            if (this.pLockMapper.reduceByExample(reduce) > 0) {
                PLockExample example = new PLockExample();
                example.createCriteria().andLockNameEqualTo(name).andLockKeyEqualTo(key).andLimitTimeLessThan(new Date());
                example.or().andLockNameEqualTo(name).andLockKeyEqualTo(key).andLockCountLessThan(1);
                if (this.pLockMapper.deleteByExample(example) > 0) {
                    this.getKeyMap().remove(name);
                }
            } else {
                this.getKeyMap().remove(name);
            }
        }
    }

    public String getName() {
        return "\u5206\u5e03\u5f0f\u5e76\u53d1\u9501-\u6570\u636e\u5e93";
    }
}

