/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.stream.AutoCloseInputStreamWapper;
import com.help.common.util.StreamUtils;
import com.help.common.util.StringUtil;
import com.help.config.HelpCrcbAmazonConfig;
import com.help.storage.HelpAmazonFileInfo;
import com.help.storage.HelpAmazonRequest;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpCrcbAmazonClient {
    private static final String FILE_NAME_META_KEY = "file-name";
    public static Logger logger = LoggerFactory.getLogger(HelpCrcbAmazonClient.class);
    private HelpCrcbAmazonConfig config;
    private AmazonS3 amazonS3;

    @PreDestroy
    private void shutdown() {
        this.amazonS3.shutdown();
    }

    public HelpCrcbAmazonClient(HelpCrcbAmazonConfig config) {
        this.config = config;
        String accessKey = config.getAccessKey();
        String secretKey = config.getSecretKey();
        String bucketName = config.getBucketName();
        this.amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey)))).withClientConfiguration(new ClientConfiguration().withProtocol(Protocol.HTTP).withConnectionTimeout(config.getConnectionTimeout()).withRequestTimeout(config.getRequestTimeout()).withSocketTimeout(config.getSocketTimeout()).withSignerOverride("S3SignerType").withUseExpectContinue(true).withMaxConnections(config.getPoolSize()).withConnectionTTL((long)config.getConnectionTtl()))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(config.getUrl(), ""))).withPathStyleAccessEnabled(Boolean.valueOf(true))).build();
        boolean b = this.amazonS3.doesBucketExistV2(bucketName);
        if (!b) {
            logger.warn("OSS\u5bf9\u8c61\u5b58\u50a8Bucket[{}]\u4e0d\u5b58\u5728", (Object)config.getBucketName());
        }
    }

    public String getMime(String fileId) {
        return this.getMime(fileId, this.config.getBucketName());
    }

    public String getMime(String fileId, String bucketName) {
        boolean b = this.judgeKey(fileId, bucketName);
        if (!b) {
            throw new UnifyException(UnifyErrorCode.NON_DATA, "\u6587\u4ef6\u670d\u52a1\u5668\u65e0\u6587\u4ef6");
        }
        GetObjectMetadataRequest request = new GetObjectMetadataRequest(bucketName, fileId);
        return this.amazonS3.getObjectMetadata(request).getContentType();
    }

    public String save(byte[] file, String originalFileName) {
        return this.save(new HelpAmazonRequest().withData(file).withOriginalFileName(originalFileName));
    }

    public String save(InputStream is, String originalFileName) {
        return this.save(new HelpAmazonRequest().withInputStream(is).withOriginalFileName(originalFileName));
    }

    public String save(File file) {
        return this.save(new HelpAmazonRequest().withFile(file));
    }

    public String save(HelpAmazonRequest request) {
        String bucketName;
        String id;
        if (request.getPermission() == null) {
            request.setPermission(this.config.getDefaultPermission());
        }
        if (StringUtil.isEmpty((String)request.getFileId())) {
            request.setFileId(UUID.randomUUID().toString().replace("-", ""));
        }
        ObjectMetadata objectMetadata = new ObjectMetadata();
        if (StringUtil.isNotEmpty((String)request.getOriginalFileName())) {
            objectMetadata.addUserMetadata(FILE_NAME_META_KEY, this.encodeFileName(request.getOriginalFileName()));
        }
        if (request.getMetadata() != null) {
            for (String k : request.getMetadata().keySet()) {
                objectMetadata.addUserMetadata(k, request.getMetadata().get(k));
            }
        }
        if (StringUtil.isEmpty((String)request.getMime())) {
            if (StringUtil.isNotEmpty((String)request.getOriginalFileName())) {
                objectMetadata.setContentType(Mimetypes.getInstance().getMimetype(request.getOriginalFileName()));
            } else {
                objectMetadata.setContentType("application/octet-stream");
            }
        } else {
            objectMetadata.setContentType(request.getMime());
        }
        if (request.getSize() != -1L) {
            objectMetadata.setContentLength(request.getSize());
        }
        if (StringUtil.isEmpty((String)(id = request.getFileId()))) {
            id = UUID.randomUUID().toString().replace("-", "");
        }
        if (StringUtil.isEmpty((String)(bucketName = request.getBucketName()))) {
            bucketName = this.config.getBucketName();
        }
        if (request.getData() != null) {
            this.amazonS3.putObject(new PutObjectRequest(bucketName, id, (InputStream)new ByteArrayInputStream(request.getData()), objectMetadata).withCannedAcl(request.getPermission()));
        } else if (request.getInputStream() != null) {
            this.amazonS3.putObject(new PutObjectRequest(bucketName, id, request.getInputStream(), objectMetadata).withCannedAcl(request.getPermission()));
        } else if (request.getFile() != null) {
            this.amazonS3.putObject(new PutObjectRequest(bucketName, id, request.getFile()).withMetadata(objectMetadata).withCannedAcl(request.getPermission()));
        } else {
            throw new IllegalArgumentException("\u6587\u4ef6\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return id;
    }

    public void delete(String fileId) {
        this.delete(fileId, this.config.getBucketName());
    }

    public void delete(String fileId, String bucketName) {
        this.amazonS3.deleteObject(bucketName, fileId);
    }

    public byte[] get(String fileId) {
        return this.get(fileId, this.config.getBucketName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] get(String fileId, String bucketName) {
        try (InputStream is = this.getInputStream(fileId, bucketName);){
            byte[] byArray = StreamUtils.copyToByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            throw new UnifyException("\u6587\u4ef6[" + fileId + "]\u8bfb\u53d6\u5931\u8d25");
        }
    }

    public InputStream getInputStream(String fileId) {
        return this.getInputStream(fileId, this.config.getBucketName());
    }

    public InputStream getInputStream(String fileId, String bucketName) {
        boolean b = this.judgeKey(fileId, bucketName);
        if (!b) {
            throw new UnifyException("\u6587\u4ef6\u670d\u52a1\u5668\u65e0\u6587\u4ef6");
        }
        GetObjectRequest request = new GetObjectRequest(bucketName, fileId);
        S3Object object = this.amazonS3.getObject(request);
        return new AutoCloseInputStreamWapper((InputStream)object.getObjectContent(), new Closeable[]{object});
    }

    public long getSize(String fileId) {
        return this.getSize(fileId, this.config.getBucketName());
    }

    public long getSize(String fileId, String bucketName) {
        boolean b = this.judgeKey(fileId, bucketName);
        if (!b) {
            throw new UnifyException(UnifyErrorCode.NON_DATA, "\u6587\u4ef6\u670d\u52a1\u5668\u65e0\u6587\u4ef6");
        }
        GetObjectMetadataRequest request = new GetObjectMetadataRequest(bucketName, fileId);
        return this.amazonS3.getObjectMetadata(request).getContentLength();
    }

    public String getUrl(String fileId) {
        return this.getUrl(fileId, this.config.getBucketName());
    }

    public String getUrl(String fileId, String bucketName) {
        return this.amazonS3.getUrl(bucketName, fileId).toString();
    }

    public String getFileName(String fileId) {
        return this.getFileName(fileId, this.config.getBucketName());
    }

    public String getFileName(String fileId, String bucketName) {
        boolean b = this.judgeKey(fileId, bucketName);
        if (!b) {
            throw new UnifyException(UnifyErrorCode.NON_DATA, "\u6587\u4ef6\u670d\u52a1\u5668\u65e0\u6587\u4ef6");
        }
        GetObjectMetadataRequest request = new GetObjectMetadataRequest(bucketName, fileId);
        String name = this.amazonS3.getObjectMetadata(request).getUserMetaDataOf(FILE_NAME_META_KEY);
        return this.decodeFileName(name);
    }

    public HelpAmazonFileInfo getFileInfo(String fileId) {
        return this.getFileInfo(fileId, this.config.getBucketName());
    }

    public HelpAmazonFileInfo getFileInfo(String fileId, String bucketName) {
        boolean b = this.judgeKey(fileId, bucketName);
        if (!b) {
            throw new UnifyException(UnifyErrorCode.NON_DATA, "\u6587\u4ef6\u670d\u52a1\u5668\u65e0\u6587\u4ef6");
        }
        GetObjectMetadataRequest request = new GetObjectMetadataRequest(bucketName, fileId);
        ObjectMetadata mt = this.amazonS3.getObjectMetadata(request);
        HelpAmazonFileInfo fileInfo = new HelpAmazonFileInfo();
        fileInfo.setFileId(fileId);
        fileInfo.setBucket(bucketName);
        fileInfo.setFileName(this.getFileName(mt));
        fileInfo.setMime(mt.getContentType());
        fileInfo.setSize(mt.getContentLength());
        HashMap<String, String> userMetadata = mt.getUserMetadata();
        if (userMetadata == null) {
            userMetadata = new HashMap<String, String>();
        } else {
            userMetadata.remove(FILE_NAME_META_KEY);
        }
        fileInfo.setMetadata(userMetadata);
        return fileInfo;
    }

    public void setPermission(String fileId, CannedAccessControlList acl) {
        this.setPermission(fileId, this.config.getBucketName(), acl);
    }

    public void setPermission(String fileId, String bucketName, CannedAccessControlList acl) {
        this.amazonS3.setObjectAcl(bucketName, fileId, acl);
    }

    private String getFileName(ObjectMetadata mt) {
        if (mt == null) {
            return "\u672a\u77e5";
        }
        String name = mt.getUserMetaDataOf(FILE_NAME_META_KEY);
        return this.decodeFileName(name);
    }

    private String encodeFileName(String name) {
        try {
            return URLEncoder.encode(name, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return "\u672a\u77e5";
        }
    }

    private String decodeFileName(String name) {
        if (StringUtil.isNotEmpty((String)name)) {
            try {
                return URLDecoder.decode(name, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                return "\u672a\u77e5";
            }
        }
        return "\u672a\u77e5";
    }

    public AmazonS3 getOriginalClient() {
        return this.amazonS3;
    }

    public boolean judgeKey(String fileId, String bucketName) {
        return this.amazonS3.doesObjectExist(bucketName, fileId);
    }
}

