/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.help.SequenceGeneratorConfig;
import com.help.autoconfig.HelpDataSourceAutoConfiguration;
import com.help.constraint.ISerNoGenerator;
import com.help.dao.PAutocodeMapper;
import com.help.dao.PAutoseqMapper;
import com.help.dao.SequenceMapper;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;

@ConditionalOnClass(value={SequenceMapper.class, PAutocodeMapper.class, PAutoseqMapper.class, SequenceGeneratorConfig.class})
@AutoConfigureAfter(value={HelpDataSourceAutoConfiguration.class})
@ConditionalOnBean(value={DataSource.class}, name={"defaultDataSource"})
public class SernoGeneratorAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(SernoGeneratorAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="help.sequence")
    public SequenceGeneratorConfig sernoGeneratorConfig() {
        return new SequenceGeneratorConfig();
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
    @ConditionalOnBean(value={SequenceGeneratorConfig.class})
    @ConditionalOnMissingBean(value={ISerNoGenerator.class})
    public SequenceMapper iSerNoGenerator(SequenceGeneratorConfig config) {
        SequenceMapper mapper = new SequenceMapper(config.getCache());
        this.logger.info("\u68c0\u6d4b\u5230MyBatis\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[\u5e8f\u5217\u53f7\u751f\u6210\u5668(\u6570\u636e\u5e93)],\u7f13\u5b58\u5927\u5c0f:[" + config.getCache() + "]");
        return mapper;
    }
}

