/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.github.pagehelper.PageInterceptor;
import com.help.autoconfig.HelpDataSourceAutoConfiguration;
import com.help.autoconfig.HelpMyBatisAutoConfiguration;
import com.help.autoconfig.HelpMyBatisConfigAutoConfiguration;
import com.help.common.util.Convert;
import com.help.datasource.config.HelpMybatisConfig;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={PageInterceptor.class})
@ConditionalOnBean(value={HelpMybatisConfig.class, DataSource.class}, name={"defaultDataSource"})
@AutoConfigureBefore(value={HelpMyBatisAutoConfiguration.class})
@AutoConfigureAfter(value={HelpDataSourceAutoConfiguration.class, HelpMyBatisConfigAutoConfiguration.class})
public class PagedPluginAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(PagedPluginAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public PageInterceptor multiDataSourceMyBatisInterceptor(HelpMybatisConfig helpMybatisConfig) {
        PageInterceptor pageHelper = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("offsetAsPageNum", Convert.toString((Object)helpMybatisConfig.isOffsetAsPageNum()));
        properties.setProperty("rowBoundsWithCount", Convert.toString((Object)helpMybatisConfig.isRowBoundsWithCount()));
        properties.setProperty("autoRuntimeDialect", "true");
        pageHelper.setProperties(properties);
        this.logger.info("\u68c0\u6d4b\u5230MyBatis\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[MyBatis\u6570\u636e\u5e93\u67e5\u8be2\u5206\u9875\u7ec4\u4ef6]");
        return pageHelper;
    }
}

