/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.help.autoconfig.HelpDataSourceAutoConfiguration;
import com.help.autoconfig.HelpMyBatisAutoConfiguration;
import com.help.datasource.HelpDynamicDataSource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@ConditionalOnSingleCandidate(value=DataSource.class)
@AutoConfigureAfter(value={HelpDataSourceAutoConfiguration.class, HelpMyBatisAutoConfiguration.class})
@EnableTransactionManagement
public class HelpTransactionManagerAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpTransactionManagerAutoConfiguration.class);

    @Bean
    @ConditionalOnBean(value={DataSource.class})
    @ConditionalOnMissingBean(value={TransactionManagementConfigurer.class})
    public TransactionManagementConfigurer transactionManagementConfigurer(DataSource dataSource) {
        if (dataSource instanceof HelpDynamicDataSource) {
            this.logger.info("\u68c0\u6d4b\u5230\u6570\u636e\u5e93\u591a\u6570\u636e\u6e90\u73af\u5883,\u4f46\u5f53\u524d\u7248\u672c\u4e0d\u652f\u6301XA\u4e8b\u52a1,\u81ea\u52a8\u914d\u7f6e[\u9ed8\u8ba4Spring\u6570\u636e\u5e93\u4e8b\u52a1\u7ba1\u7406\u5668],\u8bf7\u6ce8\u610f\u4e8b\u52a1\u65e0\u6cd5\u8de8\u6570\u636e\u6e90");
        } else {
            this.logger.info("\u68c0\u6d4b\u5230\u6570\u636e\u5e93\u5355\u6570\u636e\u6e90\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[\u9ed8\u8ba4Spring\u6570\u636e\u5e93\u4e8b\u52a1\u7ba1\u7406\u5668]");
        }
        return () -> new DataSourceTransactionManager(dataSource);
    }
}

