/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.incrementer.IKeyGenerator;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.help.SpringBootVFS;
import com.help.SpringScanConfig;
import com.help.autoconfig.HelpMyBatisConfigAutoConfiguration;
import com.help.common.util.StringUtil;
import com.help.datasource.config.HelpMybatisConfig;
import com.help.datasource.config.MyBatisSpringSupportConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.ibatis.logging.slf4j.Slf4jImpl;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@ConditionalOnBean(value={DataSource.class}, name={"defaultDataSource"})
@ConditionalOnClass(value={MybatisConfiguration.class, MapperScannerConfigurer.class, SqlSessionFactory.class})
@AutoConfigureBefore(value={HelpMyBatisConfigAutoConfiguration.class})
public class HelpMyBatisPlusAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpMyBatisPlusAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public MybatisPlusProperties mybatisPlusProperties() {
        return new MybatisPlusProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public PaginationInterceptor paginationInterceptor() {
        return new PaginationInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlSessionFactory sqlSessionFactory(@Autowired ApplicationContext applicationContext, @Autowired MybatisPlusProperties mybatisPlusProperties, @Autowired SpringScanConfig springScanConfig, DataSource dataSource, HelpMybatisConfig helpMybatisConfig, MyBatisSpringSupportConfig myBatisSpringSupportConfig, @Autowired(required=false) List<Interceptor> interceptors, @Autowired(required=false) TransactionFactory transactionFactory) {
        MybatisConfiguration conf = new MybatisConfiguration();
        conf.setMapUnderscoreToCamelCase(true);
        conf.setLogImpl(Slf4jImpl.class);
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setConfiguration(conf);
        bean.setTransactionFactory(transactionFactory);
        bean.setVfs(SpringBootVFS.class);
        if (myBatisSpringSupportConfig.getTypeAliasesSuperType() != null) {
            bean.setTypeAliasesSuperType(myBatisSpringSupportConfig.getTypeAliasesSuperType());
        }
        if (myBatisSpringSupportConfig.getTypeAliasesPackage() != null) {
            bean.setTypeAliasesPackage(myBatisSpringSupportConfig.getTypeAliasesPackage());
        }
        if (interceptors != null) {
            bean.setPlugins(interceptors.toArray(new Interceptor[0]));
        }
        try {
            List<Object> mapperLocation = new ArrayList<String>();
            if (helpMybatisConfig.getMapperLocation() != null) {
                mapperLocation.addAll(Arrays.asList(helpMybatisConfig.getMapperLocation()));
            }
            if (myBatisSpringSupportConfig.getMapperLocations() != null) {
                mapperLocation.addAll(Arrays.asList(myBatisSpringSupportConfig.getMapperLocations()));
            }
            mapperLocation.addAll(Arrays.stream(springScanConfig.getBasePackage()).map(p -> "classpath*:" + p.replace(".", "/") + "/**/*.xml").collect(Collectors.toList()));
            mapperLocation = mapperLocation.stream().distinct().collect(Collectors.toList());
            this.logger.info("\u68c0\u6d4b\u5230MyBatis\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[MyBatis-XML\u626b\u63cf\u5668],xml\u6587\u4ef6\u6240\u5728\u8def\u5f84[" + StringUtil.join(mapperLocation, (String)",") + "]");
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (String string : mapperLocation) {
                Resource[] all = resolver.getResources(string);
                resources.addAll(Arrays.asList(all));
            }
            bean.setMapperLocations(resources.toArray(new Resource[0]));
            this.logger.info("\u68c0\u6d4b\u5230MyBatis-Plus\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[SqlSessionFactory]");
            GlobalConfig globalConfig = mybatisPlusProperties.getGlobalConfig();
            if (applicationContext.getBeanNamesForType(MetaObjectHandler.class, false, false).length > 0) {
                MetaObjectHandler metaObjectHandler = (MetaObjectHandler)applicationContext.getBean(MetaObjectHandler.class);
                globalConfig.setMetaObjectHandler(metaObjectHandler);
            }
            if (applicationContext.getBeanNamesForType(IKeyGenerator.class, false, false).length > 0) {
                IKeyGenerator iKeyGenerator = (IKeyGenerator)applicationContext.getBean(IKeyGenerator.class);
                globalConfig.getDbConfig().setKeyGenerator(iKeyGenerator);
            }
            if (applicationContext.getBeanNamesForType(ISqlInjector.class, false, false).length > 0) {
                ISqlInjector iSqlInjector = (ISqlInjector)applicationContext.getBean(ISqlInjector.class);
                globalConfig.setSqlInjector(iSqlInjector);
            }
            bean.setGlobalConfig(globalConfig);
            return bean.getObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

