/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.help.SpringBootVFS;
import com.help.SpringScanConfig;
import com.help.autoconfig.HelpDataSourceAutoConfiguration;
import com.help.autoconfig.HelpMyBatisConfigAutoConfiguration;
import com.help.common.util.StringUtil;
import com.help.dao.batch.BatchHelper;
import com.help.datasource.HelpDynamicDataSource;
import com.help.datasource.HelpDynamicTransactionFactory;
import com.help.datasource.config.HelpMybatisConfig;
import com.help.datasource.config.MyBatisSpringSupportConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.logging.slf4j.Slf4jImpl;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@ConditionalOnBean(value={DataSource.class}, name={"defaultDataSource"})
@ConditionalOnClass(value={MapperScannerConfigurer.class, SqlSessionFactory.class})
@AutoConfigureAfter(value={HelpDataSourceAutoConfiguration.class, HelpMyBatisConfigAutoConfiguration.class})
public class HelpMyBatisAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpMyBatisAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public MapperScannerConfigurer mapperScannerConfigurer(SpringScanConfig springScanConfig) {
        MapperScannerConfigurer mapperScannerConfigurer = new MapperScannerConfigurer();
        mapperScannerConfigurer.setBasePackage(StringUtil.join((String[])springScanConfig.getBasePackage(), (String)","));
        mapperScannerConfigurer.setAnnotationClass(Mapper.class);
        this.logger.info("\u68c0\u6d4b\u5230MyBatis\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[MyBatis-Mapper\u626b\u63cf\u5668],\u57fa\u7840\u5305\u76ee\u5f55:[" + StringUtil.join((String[])springScanConfig.getBasePackage(), (String)",") + "]");
        return mapperScannerConfigurer;
    }

    @Bean
    @ConditionalOnMissingBean
    public TransactionFactory transactionFactory(DataSource dataSource) {
        if (dataSource instanceof HelpDynamicDataSource) {
            this.logger.info("\u68c0\u6d4b\u5230\u591a\u6570\u636e\u6e90\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[HELP-Mybatis\u52a8\u6001\u4e8b\u52a1\u7ba1\u7406\u5668]");
            return new HelpDynamicTransactionFactory();
        }
        this.logger.info("\u68c0\u6d4b\u5230\u5355\u6570\u636e\u6e90\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[Spring-MyBatis\u9ed8\u8ba4\u4e8b\u52a1\u7ba1\u7406\u5668]");
        return new SpringManagedTransactionFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlSessionFactory sqlSessionFactory(@Autowired SpringScanConfig springScanConfig, @Qualifier(value="defaultDataSource") DataSource dataSource, HelpMybatisConfig helpMybatisConfig, MyBatisSpringSupportConfig myBatisSpringSupportConfig, @Autowired(required=false) List<Interceptor> interceptors, @Autowired(required=false) TransactionFactory transactionFactory) {
        Configuration conf = new Configuration();
        conf.setMapUnderscoreToCamelCase(true);
        conf.setLogImpl(Slf4jImpl.class);
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setConfiguration(conf);
        bean.setTransactionFactory(transactionFactory);
        bean.setVfs(SpringBootVFS.class);
        if (myBatisSpringSupportConfig.getTypeAliasesSuperType() != null) {
            bean.setTypeAliasesSuperType(myBatisSpringSupportConfig.getTypeAliasesSuperType());
        }
        if (myBatisSpringSupportConfig.getTypeAliasesPackage() != null) {
            bean.setTypeAliasesPackage(myBatisSpringSupportConfig.getTypeAliasesPackage());
        }
        if (interceptors != null) {
            bean.setPlugins(interceptors.toArray(new Interceptor[0]));
        }
        try {
            List<Object> mapperLocation = new ArrayList<String>();
            if (helpMybatisConfig.getMapperLocation() != null) {
                mapperLocation.addAll(Arrays.asList(helpMybatisConfig.getMapperLocation()));
            }
            if (myBatisSpringSupportConfig.getMapperLocations() != null) {
                mapperLocation.addAll(Arrays.asList(myBatisSpringSupportConfig.getMapperLocations()));
            }
            mapperLocation.addAll(Arrays.stream(springScanConfig.getBasePackage()).map(p -> "classpath*:" + p.replace(".", "/") + "/**/*.xml").collect(Collectors.toList()));
            mapperLocation = mapperLocation.stream().distinct().collect(Collectors.toList());
            this.logger.info("\u68c0\u6d4b\u5230MyBatis\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[MyBatis-XML\u626b\u63cf\u5668],xml\u6587\u4ef6\u6240\u5728\u8def\u5f84[" + StringUtil.join(mapperLocation, (String)",") + "]");
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (String string : mapperLocation) {
                Resource[] all = resolver.getResources(string);
                resources.addAll(Arrays.asList(all));
            }
            bean.setMapperLocations(resources.toArray(new Resource[0]));
            this.logger.info("\u68c0\u6d4b\u5230MyBatis\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[SqlSessionFactory]");
            return bean.getObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        this.logger.info("\u68c0\u6d4b\u5230MyBatis\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[SqlSessionTemplate]");
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Bean
    @ConditionalOnBean(value={SqlSessionFactory.class})
    @ConditionalOnMissingBean
    public BatchHelper batchHelper(SqlSessionFactory sqlSessionFactory) {
        this.logger.info("\u68c0\u6d4b\u5230MyBatis\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[HELP\u5e73\u53f0MyBatis\u6279\u5904\u7406\u652f\u6301\u7ec4\u4ef6]");
        return new BatchHelper(sqlSessionFactory);
    }
}

