/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.help.autoconfig.HelpDataSourceAutoConfiguration;
import com.help.datasource.HelpDynamicDataSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={HttpServlet.class, Filter.class})
@AutoConfigureAfter(value={HelpDataSourceAutoConfiguration.class})
@ConditionalOnBean(value={HelpDataSourceAutoConfiguration.class})
@ConditionalOnWebApplication
public class HelpDruidFilterAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpDruidFilterAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={WebStatFilter.class}, parameterizedContainer={FilterRegistrationBean.class})
    public FilterRegistrationBean<WebStatFilter> druidStatFilterRegister() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new WebStatFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("druidWebStatFilter");
        registration.setOrder(5);
        registration.addInitParameter("exclusions", "*.js,*.gif,*.jpg,*.bmp,*.png,*.css,*.ico,/druid/*");
        registration.addInitParameter("profileEnable", "true");
        registration.addInitParameter("sessionStatEnable", "false");
        this.logger.info("\u68c0\u6d4b\u5230WEB\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[Druid\u6570\u636e\u91c7\u96c6\u5668]");
        return registration;
    }

    @Bean
    @ConfigurationProperties(value="druid")
    public HelpDruidFilterConfig helpDruidFilterConfig() {
        return new HelpDruidFilterConfig();
    }

    @Bean
    @ConditionalOnBean(value={HelpDruidFilterConfig.class, DataSource.class})
    @ConditionalOnMissingBean(value={StatViewServlet.class}, parameterizedContainer={ServletRegistrationBean.class})
    public ServletRegistrationBean<StatViewServlet> druidStatViewServletRegister(HelpDruidFilterConfig helpDruidFilterConfig, @Autowired List<DataSource> dataSources) {
        for (DataSource ds : dataSources) {
            Map map;
            if (ds instanceof DruidDataSource) {
                try {
                    if (((DruidDataSource)ds).getFilterClassNames() != null && ((DruidDataSource)ds).getFilterClassNames().size() != 0) continue;
                    ((DruidDataSource)ds).setFilters("stat");
                }
                catch (SQLException e) {
                    this.logger.warn("\u4e3aDruid\u6570\u636e\u6e90\u6ce8\u5165\u6570\u636e\u5e93\u76d1\u63a7\u5931\u8d25[" + e.getMessage() + "]", (Throwable)e);
                }
                continue;
            }
            if (!(ds instanceof HelpDynamicDataSource) || (map = ((HelpDynamicDataSource)ds).getTargetDataSources()) == null || map.size() <= 0) continue;
            Collection targets = map.values();
            for (Object o : targets) {
                if (!(o instanceof DruidDataSource)) continue;
                try {
                    ((DruidDataSource)o).setFilters("stat");
                }
                catch (SQLException e) {
                    this.logger.warn("\u4e3aDruid\u6570\u636e\u6e90[" + ((DruidDataSource)o).getName() + "]\u6ce8\u5165\u6570\u636e\u5e93\u76d1\u63a7\u5931\u8d25[" + e.getMessage() + "]", (Throwable)e);
                }
            }
        }
        ServletRegistrationBean bean = new ServletRegistrationBean();
        bean.addUrlMappings(new String[]{"/druid/*"});
        bean.addInitParameter("loginUsername", helpDruidFilterConfig.getLoginUsername());
        bean.addInitParameter("loginPassword", helpDruidFilterConfig.getLoginPassword());
        bean.addInitParameter("resetEnable", "false");
        bean.setServlet((Servlet)new StatViewServlet());
        this.logger.info("\u68c0\u6d4b\u5230WEB\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[Druid\u76d1\u63a7\u754c\u9762],\u8bbf\u95ee\u8def\u5f84[/druid]");
        return bean;
    }

    public static class HelpDruidFilterConfig {
        private String loginUsername = "admin";
        private String loginPassword = "123456";

        public String getLoginUsername() {
            return this.loginUsername;
        }

        public void setLoginUsername(String loginUsername) {
            this.loginUsername = loginUsername;
        }

        public String getLoginPassword() {
            return this.loginPassword;
        }

        public void setLoginPassword(String loginPassword) {
            this.loginPassword = loginPassword;
        }
    }
}

