/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.StringUtil;
import com.help.datasource.DefaultDataSourceBuilder;
import com.help.datasource.HelpDynamicDataSource;
import com.help.datasource.IDataSourceBuilder;
import com.help.datasource.config.HelpDataSourceConfig;
import com.help.datasource.config.HelpDataSourceConfigGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={HelpDataSourceConfigGroup.class})
@ConditionalOnMissingBean(name={"defaultDataSource"})
@ConditionalOnExpression(value="!'${help.datasource.multi[0].url:null}'.equalsIgnoreCase('null') || !'${spring.datasource.url:null}'.equalsIgnoreCase('null')")
public class HelpDataSourceAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpDataSourceAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(prefix="spring.datasource", name={"url"})
    @ConfigurationProperties(value="spring.datasource")
    public HelpDataSourceConfig defaultSpringDataSourceConfig() {
        return new HelpDataSourceConfig();
    }

    @Bean
    @ConfigurationProperties(value="help.datasource")
    public HelpDataSourceConfigGroup helpDataSourceConfigGroup() {
        return new HelpDataSourceConfigGroup();
    }

    @Bean(value={"defaultDataSource"})
    @ConditionalOnBean(value={HelpDataSourceConfigGroup.class})
    @ConditionalOnExpression(value="!'${help.datasource.multi[1].url:null}'.equalsIgnoreCase('null') || !'${help.datasource.multi[0].url:null}'.equalsIgnoreCase('null') && !'${spring.datasource.url:null}'.equalsIgnoreCase('null')")
    public HelpDynamicDataSource helpDynamicDataSource(HelpDataSourceConfigGroup config, @Autowired(required=false) HelpDataSourceConfig defaultSpringDataSourceConfig, @Autowired(required=false) List<IDataSourceBuilder> iDataSourceBuilderList) {
        this.buildConfigGroup(config, defaultSpringDataSourceConfig);
        Map<String, DataSource> dataSources = this.buildDataSource(config, iDataSourceBuilderList);
        HelpDynamicDataSource dynamicDataSource = new HelpDynamicDataSource();
        DataSource dft = null;
        if (dataSources.containsKey(dataSources.get("default"))) {
            dft = dataSources.get("default");
        }
        HashMap<String, DataSource> targetDataSource = new HashMap<String, DataSource>(dataSources.size());
        for (String key : dataSources.keySet()) {
            if (dft == null) {
                dft = dataSources.get(key);
            }
            targetDataSource.put(key, dataSources.get(key));
        }
        dynamicDataSource.setTargetDataSources(targetDataSource);
        dynamicDataSource.setDefaultTargetDataSource((Object)dft);
        return dynamicDataSource;
    }

    @Bean(value={"defaultDataSource"})
    @ConditionalOnMissingBean(value={HelpDynamicDataSource.class})
    @ConditionalOnBean(value={HelpDataSourceConfigGroup.class})
    public DataSource defaultDataSource(HelpDataSourceConfigGroup config, @Autowired(required=false) HelpDataSourceConfig defaultSpringDataSourceConfig, @Autowired(required=false) List<IDataSourceBuilder> iDataSourceBuilderList) {
        this.buildConfigGroup(config, defaultSpringDataSourceConfig);
        Map<String, DataSource> dataSources = this.buildDataSource(config, iDataSourceBuilderList);
        return dataSources.values().stream().findFirst().orElse(null);
    }

    private void buildConfigGroup(HelpDataSourceConfigGroup config, HelpDataSourceConfig defaultSpringDataSourceConfig) {
        if (defaultSpringDataSourceConfig != null) {
            if (config.getDefaultDataSource() != null) {
                if (config.getMulti() != null && config.getMulti().length > 0) {
                    ArrayList<HelpDataSourceConfig> configs = new ArrayList<HelpDataSourceConfig>(Arrays.asList(config.getMulti()));
                    configs.add(0, defaultSpringDataSourceConfig);
                    config.setMulti(configs.toArray(new HelpDataSourceConfig[0]));
                } else {
                    config.setMulti(new HelpDataSourceConfig[]{defaultSpringDataSourceConfig});
                }
            } else {
                config.setDefaultDataSource(defaultSpringDataSourceConfig);
            }
        }
    }

    private Map<String, DataSource> buildDataSource(HelpDataSourceConfigGroup config, List<IDataSourceBuilder> iDataSourceBuilderList) {
        ArrayList<HelpDataSourceConfig> configs = new ArrayList<HelpDataSourceConfig>();
        if (config.getDefaultDataSource() != null) {
            configs.add(config.getDefaultDataSource());
        }
        if (config.getMulti() != null && config.getMulti().length > 0) {
            configs.addAll(Arrays.asList(config.getMulti()));
        }
        int count = configs.size();
        boolean contailDefault = configs.stream().anyMatch(p -> "default".equals(p.getName()));
        DefaultDataSourceBuilder defaultDataSourceBuilder = new DefaultDataSourceBuilder();
        HashMap<String, DataSource> dataSources = new HashMap<String, DataSource>();
        for (int i = 0; i < configs.size(); ++i) {
            HelpDataSourceConfig c = (HelpDataSourceConfig)configs.get(i);
            String name = null;
            name = StringUtil.isNotEmpty((String)c.getName()) ? c.getName() : (!contailDefault && i == 0 ? "default" : "dataSource" + i);
            c.setName(name);
            DataSource dataSource = null;
            if (iDataSourceBuilderList != null && iDataSourceBuilderList.size() > 0) {
                for (IDataSourceBuilder builder : iDataSourceBuilderList) {
                    if (!builder.support(c)) continue;
                    dataSource = builder.buildDataSource(c);
                    break;
                }
            }
            if (dataSource == null && defaultDataSourceBuilder.support(c)) {
                dataSource = defaultDataSourceBuilder.buildDataSource(c);
            }
            if (dataSource == null) {
                throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301\u6570\u636e\u5e93[" + c.getUrl() + "]");
            }
            if (count > 1) {
                this.logger.info("\u68c0\u6d4b\u5230HELP\u5e73\u53f0\u9ed8\u8ba4\u591a\u6570\u636e\u6e90\u73af\u5883,\u81ea\u52a8\u914d\u7f6e[\u975eXA\u4e8b\u52a1\u578b]\u6570\u636e\u6e90[" + name + "](" + c.getUrl() + ")");
            } else {
                this.logger.info("\u68c0\u6d4b\u5230HELP\u5e73\u53f0\u9ed8\u8ba4\u6570\u636e\u6e90\u73af\u5883,\u81ea\u52a8\u914d\u7f6e\u6570\u636e\u6e90(" + c.getUrl() + ")");
            }
            dataSources.put(name, dataSource);
        }
        return dataSources;
    }
}

