package com.help.autoconfig;

import com.help.SequenceGeneratorConfig;
import com.help.constraint.ISerNoGenerator;
import com.help.dao.PAutocodeMapper;
import com.help.dao.PAutoseqMapper;
import com.help.dao.SequenceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;

import javax.sql.DataSource;

/**
 * Help平台序列号/流水号生成器自动配置工具
 */
@ConditionalOnClass({SequenceMapper.class, PAutocodeMapper.class, PAutoseqMapper.class, SequenceGeneratorConfig.class})
@AutoConfigureAfter(HelpDataSourceAutoConfiguration.class)
@ConditionalOnBean(DataSource.class)
public class SernoGeneratorAutoConfiguration {

    Logger logger = LoggerFactory.getLogger(SernoGeneratorAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties("help.sequence")
    public SequenceGeneratorConfig sernoGeneratorConfig() {
        return new SequenceGeneratorConfig();
    }

    @Bean
    @Scope(proxyMode = ScopedProxyMode.TARGET_CLASS)
    @ConditionalOnBean(SequenceGeneratorConfig.class)
    @ConditionalOnMissingBean(ISerNoGenerator.class)
    public SequenceMapper iSerNoGenerator(SequenceGeneratorConfig config) {

        SequenceMapper mapper = new SequenceMapper(config.getCache());
        logger.info("检测到MyBatis环境,自动配置[序列号生成器(数据库)],缓存大小:[" + config.getCache() + "]");

        return mapper;
    }

}
