package com.help.autoconfig;

import com.help.constraint.ISerNoGenerator;
import com.help.dao.plugin.PkGeneratorInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

import javax.sql.DataSource;

/**
 * MyBatis主键生成器自动配置工具
 */
@ConditionalOnClass({ISerNoGenerator.class, PkGeneratorInterceptor.class})
@ConditionalOnBean(DataSource.class)
@AutoConfigureBefore(HelpMyBatisAutoConfiguration.class)
@AutoConfigureAfter(SernoGeneratorAutoConfiguration.class)
public class PkGeneratorAutoConfiguration {

    Logger logger = LoggerFactory.getLogger(PkGeneratorAutoConfiguration.class);

    @Bean
    @ConditionalOnBean(ISerNoGenerator.class)
    @ConditionalOnMissingBean
    public PkGeneratorInterceptor pkGeneratorInterceptor(ISerNoGenerator iSerNoGenerator) {
        PkGeneratorInterceptor interceptor = new PkGeneratorInterceptor(iSerNoGenerator);

        logger.info("检测到[主键生成器],自动配置[MyBatis主键生成插件]");

        return interceptor;
    }

}
