package com.help.autoconfig;

import com.github.pagehelper.PageInterceptor;
import com.help.datasource.config.HelpMybatisConfig;
import com.help.common.util.Convert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

import javax.sql.DataSource;
import java.util.Properties;

/**
 * MyBatis分页插件自动配置工具
 */
@ConditionalOnClass(PageInterceptor.class)
@ConditionalOnBean({DataSource.class, HelpMybatisConfig.class})
@AutoConfigureBefore(HelpMyBatisAutoConfiguration.class)
@AutoConfigureAfter({HelpDataSourceAutoConfiguration.class, HelpMyBatisConfigAutoConfiguration.class})
public class PagedPluginAutoConfiguration {

    Logger logger = LoggerFactory.getLogger(PagedPluginAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public PageInterceptor multiDataSourceMyBatisInterceptor(HelpMybatisConfig helpMybatisConfig) {

        //分页插件
        PageInterceptor pageHelper = new PageInterceptor();
        Properties properties = new Properties();

        properties.setProperty("offsetAsPageNum", Convert.toString(helpMybatisConfig.isOffsetAsPageNum()));
        properties.setProperty("rowBoundsWithCount", Convert.toString(helpMybatisConfig.isRowBoundsWithCount()));
        properties.setProperty("autoRuntimeDialect", "true");
        pageHelper.setProperties(properties);

        logger.info("检测到MyBatis环境,自动配置[MyBatis数据库查询分页组件]");

        return pageHelper;
    }

}
