package com.help.autoconfig;

import com.help.datasource.HelpDynamicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

import javax.sql.DataSource;

@ConditionalOnSingleCandidate(DataSource.class)
@AutoConfigureAfter({HelpDataSourceAutoConfiguration.class, HelpMyBatisAutoConfiguration.class})
@EnableTransactionManagement
public class HelpTransactionManagerAutoConfiguration {

    Logger logger = LoggerFactory.getLogger(HelpTransactionManagerAutoConfiguration.class);

    @Bean
    @ConditionalOnBean(DataSource.class)
    @ConditionalOnMissingBean(TransactionManagementConfigurer.class)
    public TransactionManagementConfigurer transactionManagementConfigurer(DataSource dataSource) {

        if (dataSource instanceof HelpDynamicDataSource) {
            logger.info("检测到数据库多数据源环境,但当前版本不支持XA事务,自动配置[默认Spring数据库事务管理器],请注意事务无法跨数据源");
        } else {
            logger.info("检测到数据库单数据源环境,自动配置[默认Spring数据库事务管理器]");
        }
        return () -> new DataSourceTransactionManager(dataSource);
    }

}
