package com.help.autoconfig;

import com.help.SpringScanConfig;
import com.help.datasource.config.HelpMybatisConfig;
import com.help.datasource.config.MyBatisSpringSupportConfig;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@ConditionalOnClass({MapperScannerConfigurer.class, SqlSessionFactory.class})
public class HelpMyBatisConfigAutoConfiguration {

    @Bean
    @ConfigurationProperties("help.mybatis")
    @ConditionalOnMissingBean(HelpMybatisConfig.class)
    public HelpMybatisConfig helpMybatisConfig() {
        return new HelpMybatisConfig();
    }

    @Bean
    public SpringScanConfig springScanConfig(ApplicationContext applicationContext) {
        List<String> pkgs = AutoConfigurationPackages.get(applicationContext);

        String[] names = applicationContext.getBeanNamesForAnnotation(SpringBootApplication.class);
        for (String appName : names) {
            SpringBootApplication anno = applicationContext.findAnnotationOnBean(appName, SpringBootApplication.class);
            if (anno != null) {
                if (anno.scanBasePackages() != null) {
                    pkgs.addAll(Arrays.asList(anno.scanBasePackages()));
                }
                if (anno.scanBasePackageClasses() != null) {
                    for (Class cls : anno.scanBasePackageClasses()) {
                        pkgs.add(cls.getPackage().getName());
                    }
                }
            }
        }

        String[] scanNames = applicationContext.getBeanNamesForAnnotation(ComponentScan.class);
        for (String scan : scanNames) {
            ComponentScan anno = applicationContext.findAnnotationOnBean(scan, ComponentScan.class);
            if (anno != null) {
                if (anno.basePackages() != null) {
                    pkgs.addAll(Arrays.asList(anno.basePackages()));
                }
                if (anno.value() != null) {
                    pkgs.addAll(Arrays.asList(anno.value()));
                }
                if (anno.basePackageClasses() != null) {
                    for (Class cls : anno.basePackageClasses()) {
                        pkgs.add(cls.getPackage().getName());
                    }
                }
            }
        }

        pkgs = pkgs.stream().distinct().collect(Collectors.toList());

        SpringScanConfig config = new SpringScanConfig();
        config.setBasePackage(pkgs.toArray(new String[0]));

        return config;
    }

    @Bean
    @ConfigurationProperties("mybatis")
    @ConditionalOnMissingBean(MyBatisSpringSupportConfig.class)
    public MyBatisSpringSupportConfig myBatisSpringSupportConfig() {
        return new MyBatisSpringSupportConfig();
    }

}
