package com.help.autoconfig;

import com.help.common.concurrent.IHelpLocker;
import com.help.concurrent.HelpDbLocker;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

import javax.sql.DataSource;

/**
 * HELP平台同步锁自动配置工具
 *
 * @author: YuBin-002726
 * @Date: 2019/7/8 10:26
 */
@ConditionalOnClass(DataSource.class)
@ConditionalOnBean(value = SqlSessionFactory.class, name = "defaultSqlSessionFactory")
@ConditionalOnMissingBean(IHelpLocker.class)
@AutoConfigureAfter(HelpMyBatisAutoConfiguration.class)
public class HelpLockDBAutoConfiguration {

    Logger logger = LoggerFactory.getLogger(HelpLockDBAutoConfiguration.class);

    @Bean
    public HelpDbLocker helpDbLock() {
        logger.info("检测到[数据库环境],自动配置[HELP分布式锁-数据库实现]");
        return new HelpDbLocker();
    }
}
