package com.help.autoconfig;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.help.datasource.HelpDynamicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;
import javax.sql.DataSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@ConditionalOnClass({HttpServlet.class, Filter.class})
@AutoConfigureAfter(HelpDataSourceAutoConfiguration.class)
@ConditionalOnBean({HelpDataSourceAutoConfiguration.class})
@ConditionalOnWebApplication
public class HelpDruidFilterAutoConfiguration {

    Logger logger = LoggerFactory.getLogger(HelpDruidFilterAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value = WebStatFilter.class, parameterizedContainer = FilterRegistrationBean.class)
    public FilterRegistrationBean<WebStatFilter> druidStatFilterRegister() {
        FilterRegistrationBean<WebStatFilter> registration = new FilterRegistrationBean();
        registration.setFilter(new WebStatFilter());
        registration.addUrlPatterns("/*");
        registration.setName("druidWebStatFilter");
        registration.setOrder(5);
        registration.addInitParameter("exclusions", "*.js,*.gif,*.jpg,*.bmp,*.png,*.css,*.ico,/druid/*");
        registration.addInitParameter("profileEnable", "true");
        registration.addInitParameter("sessionStatEnable", "false");
        logger.info("检测到WEB环境,自动配置[Druid数据采集器]");

        return registration;
    }


    @Bean
    @ConfigurationProperties("druid")
    public HelpDruidFilterConfig helpDruidFilterConfig() {
        return new HelpDruidFilterConfig();
    }

    @Bean
    @ConditionalOnBean({HelpDruidFilterConfig.class, DataSource.class})
    @ConditionalOnMissingBean(value = StatViewServlet.class, parameterizedContainer = ServletRegistrationBean.class)
    public ServletRegistrationBean<StatViewServlet> druidStatViewServletRegister(HelpDruidFilterConfig helpDruidFilterConfig, @Autowired List<DataSource> dataSources) {
        for (DataSource ds : dataSources) {
            if (ds instanceof DruidDataSource) {
                try {
                    if (((DruidDataSource) ds).getFilterClassNames() == null || ((DruidDataSource) ds).getFilterClassNames().size() == 0) {
                        ((DruidDataSource) ds).setFilters("stat");
                    }
                } catch (SQLException e) {
                    logger.warn("为Druid数据源注入数据库监控失败[" + e.getMessage() + "]", e);
                }
            } else if (ds instanceof HelpDynamicDataSource) {
                Map<Object, Object> map = ((HelpDynamicDataSource) ds).getTargetDataSources();
                if (map != null && map.size() > 0) {
                    Collection<Object> targets = map.values();
                    for (Object o : targets) {
                        if (o instanceof DruidDataSource) {
                            try {
                                ((DruidDataSource) o).setFilters("stat");
                            } catch (SQLException e) {
                                logger.warn("为Druid数据源[" + ((DruidDataSource) o).getName() + "]注入数据库监控失败[" + e.getMessage() + "]", e);
                            }
                        }
                    }
                }
            }
        }

        ServletRegistrationBean<StatViewServlet> bean = new ServletRegistrationBean();
        bean.addUrlMappings("/druid/*");
        bean.addInitParameter("loginUsername", helpDruidFilterConfig.getLoginUsername()); //用户名
        bean.addInitParameter("loginPassword", helpDruidFilterConfig.getLoginPassword()); // 密码
        bean.addInitParameter("resetEnable", "false");   // 禁用HTML页面上的“Reset All”功能
        bean.setServlet(new StatViewServlet());

        //bean.addInitParameter("allow","");  // IP白名单 (没有配置或者为空，则允许所有访问)
        //bean.addInitParameter("deny","");   // IP黑名单 (存在共同时，deny优先于allow)

        logger.info("检测到WEB环境,自动配置[Druid监控界面],访问路径[/druid]");

        return bean;
    }


    /**
     * Druid监控过滤器配置
     */
    public static class HelpDruidFilterConfig {
        private String loginUsername = "admin";
        private String loginPassword = "123456";

        public String getLoginUsername() {
            return loginUsername;
        }

        public void setLoginUsername(String loginUsername) {
            this.loginUsername = loginUsername;
        }

        public String getLoginPassword() {
            return loginPassword;
        }

        public void setLoginPassword(String loginPassword) {
            this.loginPassword = loginPassword;
        }
    }

}
