package com.help.autoconfig;

import com.help.datasource.obase.OBaseDataSourceBuilder;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

/**
 * @author: YuBin-002726
 * @Date: 2019/3/21 15:03
 */
@ConditionalOnClass(OBaseDataSourceBuilder.class)
@AutoConfigureBefore(HelpDataSourceAutoConfiguration.class)
public class HelpDataSourceOBaseAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean(OBaseDataSourceBuilder.class)
    public OBaseDataSourceBuilder oBaseDataSourceBuilder() {
        return new OBaseDataSourceBuilder();
    }

}
