package com.help.autoconfig;

import com.help.datasource.HelpDynamicDataSource;
import com.help.aop.DynamicDataSourceSwitchAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

/**
 * 动态数据源自动切换配置
 */
@ConditionalOnBean(HelpDynamicDataSource.class)
public class DynamicDataSourceAutoSwitchAutoConfiguration {

    Logger logger = LoggerFactory.getLogger(DynamicDataSourceAutoSwitchAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public DynamicDataSourceSwitchAspect dynamicDataSourceSwitchAspect(HelpDynamicDataSource helpDynamicDataSource) {

        logger.info("检测到多数据源环境,自动配置[动态数据源自动切换器]");

        return new DynamicDataSourceSwitchAspect(helpDynamicDataSource);
    }

}
