/*
 * Decompiled with CFR 0.152.
 */
package com.help.common;

import java.math.BigDecimal;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaDecrypt {
    static final String base64str = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    Map<String, Integer> base64IndexMap = new HashMap<String, Integer>();
    Logger log = LoggerFactory.getLogger(RsaDecrypt.class);

    public RsaDecrypt() {
        for (int i = 0; i < base64str.length(); ++i) {
            this.base64IndexMap.put(String.valueOf(base64str.charAt(i)), i);
        }
    }

    public String decrypt(String cipher, String privateKey) {
        int[] decArray = this.cipherToDecArray(cipher);
        String binaryString = this.decArrayToBinString(decArray);
        String[] binArray = this.dealBinStringToBinArray(binaryString);
        int[] enDecArray = this.binArrayToDecArray(binArray);
        int[] rsaArray = this.rsaArray(enDecArray, privateKey);
        return this.ascArrayToString(rsaArray);
    }

    public int[] cipherToDecArray(String cipher) {
        int[] array = new int[cipher.length()];
        for (int i = 0; i < cipher.length(); ++i) {
            String s = String.valueOf(cipher.charAt(i));
            array[i] = this.getBase64Index(s);
        }
        return array;
    }

    public int[] binArrayToDecArray(String[] binArray) {
        int[] decArray = new int[binArray.length];
        for (int i = 0; i < binArray.length; ++i) {
            String string2 = Integer.valueOf(binArray[i], 2).toString();
            decArray[i] = Integer.valueOf(string2);
        }
        return decArray;
    }

    public int getBase64Index(String str) {
        Integer index = this.base64IndexMap.get(str);
        if (index == null) {
            throw new RuntimeException("not found '" + str + "' base64Index");
        }
        return index;
    }

    public String decArrayToBinString(int[] decArray) {
        StringBuffer strb = new StringBuffer();
        for (int i : decArray) {
            String str = "00000000" + Integer.toBinaryString(i);
            String substring = str.substring(str.length() - 6);
            strb.append(substring);
        }
        return strb.toString();
    }

    public int rsaDecryt(int cryptASCII, int pow, int divisor) {
        BigDecimal powResult = BigDecimal.valueOf(cryptASCII).pow(pow);
        BigDecimal remainder = powResult.remainder(BigDecimal.valueOf(divisor));
        return remainder.intValue();
    }

    public String getFromBase64(String str) {
        String result = null;
        if (str == null && "".equals(str)) {
            throw new RuntimeException("getFromBase64 str is null");
        }
        try {
            byte[] b = Base64.getDecoder().decode(str);
            result = new String(b, "utf-8");
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return result;
    }

    public int[] rsaArray(int[] array, String privateKey) {
        if (privateKey == null || "".equals(privateKey)) {
            throw new RuntimeException("privateKey is null");
        }
        String string = this.getFromBase64(privateKey);
        String[] split = string.split(",");
        if (split.length != 2) {
            throw new RuntimeException("privateKey '" + privateKey + "' fromBase64: '" + string + "' error");
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.rsaDecryt(array[i], Integer.valueOf(split[1]), Integer.valueOf(split[0]));
        }
        return array;
    }

    public String ascArrayToString(int[] array) {
        StringBuffer clearText = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            clearText.append((char)Integer.parseInt(String.valueOf(array[i])));
        }
        return clearText.toString();
    }

    public String[] dealBinStringToBinArray(String str) {
        int count = str.length() / 8;
        String[] stmps = new String[count];
        for (int i = 0; i < count; ++i) {
            String substring = str.substring(0, 8);
            str = str.substring(8);
            stmps[i] = substring;
        }
        return stmps;
    }
}

