/*
 * Decompiled with CFR 0.152.
 */
package com.help;

import com.help.common.RsaDecrypt;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.http.HttpClientHelper;
import com.help.common.util.DESPlus;
import com.help.common.util.FileUtil;
import com.help.common.util.StringUtil;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

public class PropertyDecryptorAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(PropertyDecryptorAutoConfiguration.class);

    @Bean(name={"encryptablePropertyResolver"})
    @Primary
    public EncryptablePropertyResolver encryptablePropertyResolver(final @Autowired DESPlus desPlus) {
        logger.debug("HELP\u5e73\u53f0\u914d\u7f6e\u6587\u4ef6\u89e3\u5bc6\u5668\u521d\u59cb\u5316\u6210\u529f");
        try {
            return new EncryptablePropertyResolver(){

                public String resolvePropertyValue(String value) {
                    if (StringUtil.isEmpty((String)value)) {
                        return value;
                    }
                    if (value.startsWith("security:")) {
                        String v = value.substring("security:".length());
                        v = this.resolvePropertyValue(v);
                        try {
                            v = desPlus.decrypt(v);
                        }
                        catch (Exception e) {
                            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "yml\u914d\u7f6e\u6587\u4ef6\u503c[" + value + "]\u89e3\u5bc6\u5931\u8d25");
                        }
                        return this.resolvePropertyValue(v);
                    }
                    if (value.startsWith("crcb:")) {
                        String v = value.substring("crcb:".length());
                        String[] arr = (v = this.resolvePropertyValue(v)).split(" ");
                        if (arr.length != 2 && (arr = v.split("\\|")).length != 2) {
                            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "yml\u914d\u7f6e\u6587\u4ef6\u503c[" + value + "]\u89e3\u5bc6\u5931\u8d25,\u914d\u7f6e\u503c\u5fc5\u987b\u4ee5\u7a7a\u683c\u9694\u5f00\u7684\u5bc6\u6587\u548c\u5bc6\u94a5");
                        }
                        v = new RsaDecrypt().decrypt(arr[0].trim(), arr[1].trim());
                        return this.resolvePropertyValue(v);
                    }
                    if (value.startsWith("file:")) {
                        String file = value.substring("file:".length());
                        file = this.resolvePropertyValue(file);
                        logger.info("\u4ece\u914d\u7f6e\u6587\u4ef6[" + file + "]\u8bfb\u53d6\u914d\u7f6e");
                        if (FileUtil.exists((String)file)) {
                            String v = FileUtil.read((String)file).trim();
                            return this.resolvePropertyValue(v);
                        }
                        throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u4ece\u914d\u7f6e\u6587\u4ef6[" + file + "]\u8bfb\u53d6\u914d\u7f6e\u5931\u8d25,\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728");
                    }
                    if (value.startsWith("network:")) {
                        String url = value.substring("network:".length());
                        url = this.resolvePropertyValue(url);
                        logger.info("\u4eceURL[" + value + "]\u8bfb\u53d6\u914d\u7f6e");
                        try {
                            String v = HttpClientHelper.get((String)url).trim();
                            return this.resolvePropertyValue(v);
                        }
                        catch (UnifyException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u4eceURL[" + url + "]\u8bfb\u53d6\u914d\u7f6e\u5931\u8d25", (Throwable)e);
                        }
                    }
                    return value;
                }
            };
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "yml\u914d\u7f6e\u6587\u4ef6\u89e3\u5bc6\u5668\u521d\u59cb\u5316\u5931\u8d25,\u914d\u7f6e\u6587\u4ef6\u5c06\u65e0\u6cd5\u89e3\u5bc6\u539f\u6837\u8fd4\u56de");
        }
    }
}

