/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util.reflect;

import com.help.common.exception.UnifyException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ReflectUtil {
    public static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || String.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || Void.class.isAssignableFrom(clazz);
    }

    public static Field[] getAllFields(Class<?> clazz) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        while (clazz != Object.class) {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                allFields.add(f);
            }
            clazz = clazz.getSuperclass();
        }
        return allFields.toArray(new Field[allFields.size()]);
    }

    public static String[] getAllFieldNames(Class<?> clazz) {
        ArrayList<String> allFields = new ArrayList<String>();
        while (clazz != Object.class) {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                allFields.add(f.getName());
            }
            clazz = clazz.getSuperclass();
        }
        return allFields.toArray(new String[allFields.size()]);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        while (clazz != Object.class) {
            try {
                Field f = clazz.getDeclaredField(fieldName);
                if (f != null) {
                    return f;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static List<Method> getAllMethods(Class<?> clazz) {
        ArrayList<Method> allMethods = new ArrayList<Method>();
        while (clazz != Object.class) {
            Method[] m;
            for (Method f : m = clazz.getDeclaredMethods()) {
                allMethods.add(f);
            }
            clazz = clazz.getSuperclass();
        }
        return allMethods;
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        while (clazz != Object.class) {
            try {
                Method f = clazz.getDeclaredMethod(methodName, new Class[0]);
                if (f != null) {
                    return f;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Object invoke(Object obj, String methodName, Object ... params) {
        Method m = ReflectUtil.getMethod(obj.getClass(), methodName);
        if (m != null) {
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            try {
                return m.invoke(obj, params);
            }
            catch (Exception e) {
                throw new UnifyException("\u5728[" + obj.getClass() + "]\u4e0a\u8c03\u7528\u65b9\u6cd5[" + methodName + "]\u5931\u8d25", (Throwable)e);
            }
        }
        throw new UnifyException("[" + obj.getClass() + "]\u4e0d\u5b58\u5728[" + methodName + "]\u65b9\u6cd5");
    }

    public static Object invoke(Object obj, Method method, Object ... params) {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return method.invoke(obj, params);
        }
        catch (Exception e) {
            throw new UnifyException("\u5728[" + obj.getClass() + "]\u4e0a\u8c03\u7528\u65b9\u6cd5[" + method.getName() + "]\u5931\u8d25", (Throwable)e);
        }
    }
}

