/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util.reflect;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarClassLoader {
    private String jarName;
    private ClassLoader loader;
    private ClassLoader parentLoader;
    private List<String> classes;

    public JarClassLoader(String jarFileName) {
        this.jarName = jarFileName;
    }

    public JarClassLoader(String jarFileName, ClassLoader parentLoader) {
        this.jarName = jarFileName;
        this.parentLoader = parentLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getClasses() {
        JarFile jar = null;
        ArrayList<String> set = new ArrayList<String>();
        try {
            jar = new JarFile(this.jarName);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                String name = entry.getName();
                name = name.substring(0, name.length() - 6);
                name = name.replaceAll("/", ".");
                set.add(name);
            }
            ArrayList<String> arrayList = set;
            return arrayList;
        }
        catch (IOException e) {
            List<String> list = null;
            return list;
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public <T> T newInstance(String className) throws Exception {
        if (this.loader == null) {
            this.loader = this.getClassLoader();
        }
        try {
            return (T)this.loader.loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new Exception("\u5728\u6307\u5b9a\u7684jar\u5305 " + this.jarName + " \u52a0\u8f7d\u7c7b" + className + "\u5931\u8d25", e);
        }
    }

    public <T> T newInstance(Class<T> superClass) throws ClassNotFoundException, FileNotFoundException {
        if (this.loader == null) {
            this.loader = this.getClassLoader();
        }
        try {
            if (this.classes == null) {
                this.classes = this.getClasses();
            }
            for (String cname : this.classes) {
                Class<?> cls = this.loader.loadClass(cname);
                if (!superClass.isAssignableFrom(cls) || Modifier.isAbstract(cls.getModifiers()) || Modifier.isInterface(cls.getModifiers()) || !Modifier.isPublic(cls.getModifiers()) || cls.getConstructor(new Class[0]) == null) continue;
                Object obj = cls.newInstance();
                if (obj != null) {
                    return (T)obj;
                }
                throw new ClassNotFoundException("\u5728\u6307\u5b9a\u7684jar\u5305 " + this.jarName + " \u4e2d\u52a0\u8f7d\u7c7b\u5931\u8d25:" + cls.getName());
            }
            throw new ClassNotFoundException("\u5728\u6307\u5b9a\u7684jar\u5305 " + this.jarName + " \u6ca1\u6709\u627e\u5230\u5b50\u7c7b\u5b9e\u73b0");
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ClassNotFoundException("\u5728\u6307\u5b9a\u7684jar\u5305 " + this.jarName + " \u4e2d\u52a0\u8f7d\u7c7b\u5931\u8d25", e);
        }
    }

    private URLClassLoader getClassLoader() throws FileNotFoundException {
        try {
            if (this.parentLoader != null) {
                return new URLClassLoader(new URL[]{new URL("file:" + this.jarName)}, this.parentLoader);
            }
            return new URLClassLoader(new URL[]{new URL("file:" + this.jarName)});
        }
        catch (Exception e) {
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728:" + this.jarName);
        }
    }
}

