/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util.ftp;

import com.help.common.exception.UnifyException;
import com.help.common.exception.UnifySocketException;
import com.help.common.util.FileUtil;
import com.help.common.util.ftp.FTPConfig;
import com.help.common.util.ftp.IFTPExecutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.apache.commons.io.Charsets;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPUtil {
    private static Logger logger = LoggerFactory.getLogger(FTPUtil.class);
    private static Charset LOCAL_CHARSET = Charsets.UTF_8;
    private static Charset REMOTE_CHARSET = Charsets.ISO_8859_1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T execute(String url, int port, String user, String pwd, IFTPExecutor<T> executor) {
        FTPClient client = new FTPClient();
        try {
            client.connect(url, port);
            if (client.login(user, pwd)) {
                T t = executor.execute(client);
                return t;
            }
            throw new UnifySocketException("FTP\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        catch (Exception e) {
            throw new UnifySocketException("FTP\u64cd\u4f5c\u6267\u884c\u5931\u8d25", e);
        }
        finally {
            if (client.isConnected()) {
                try {
                    client.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void download(final FTPConfig config, final String remoteDir, final String localDir, final Pattern pattern) {
        FTPUtil.execute(config.getUrl(), config.getPort(), config.getUserName(), config.getPwd(), new IFTPExecutor<Void>(){

            @Override
            public Void execute(FTPClient client) throws Exception {
                client.setFileType(2);
                client.setBufferSize(1024);
                client.setControlEncoding(REMOTE_CHARSET.displayName());
                FTPUtil.downLoop(client, remoteDir, localDir, config, pattern);
                return null;
            }
        });
    }

    public static void download(FTPConfig config, String remoteDir, String localDir) {
        FTPUtil.download(config, remoteDir, localDir, null);
    }

    public static void download(String url, int port, String user, String pwd, String remoteDir, String localDir, Pattern pattern) {
        FTPConfig config = new FTPConfig(url, user, pwd);
        config.setIgnoreError(true);
        config.setIgnoreExists(true);
        config.setLoop(true);
        FTPUtil.download(config, remoteDir, localDir, pattern);
    }

    public static void download(String url, int port, String user, String pwd, String remoteDir, String localDir) {
        FTPUtil.download(url, port, user, pwd, remoteDir, localDir, null);
    }

    public static void upload(final FTPConfig config, final String remoteDir, final String localDir, final Pattern pattern) {
        FTPUtil.execute(config.getUrl(), config.getPort(), config.getUserName(), config.getPwd(), new IFTPExecutor<Void>(){

            @Override
            public Void execute(FTPClient client) throws Exception {
                client.setFileType(2);
                client.setBufferSize(1024);
                client.setControlEncoding(REMOTE_CHARSET.displayName());
                FTPUtil.upLoop(client, remoteDir, localDir, config, pattern);
                return null;
            }
        });
    }

    public static void upload(FTPConfig config, String remoteDir, String localDir) {
        FTPUtil.upload(config, remoteDir, localDir, null);
    }

    public static void upload(String url, int port, String user, String pwd, String remoteDir, String localDir, Pattern pattern) {
        FTPConfig config = new FTPConfig(url, user, pwd);
        config.setIgnoreError(true);
        config.setIgnoreExists(true);
        config.setLoop(true);
        FTPUtil.upload(config, remoteDir, localDir, pattern);
    }

    public static void upload(String url, int port, String user, String pwd, String remoteDir, String localDir) {
        FTPUtil.upload(url, port, user, pwd, remoteDir, localDir, null);
    }

    public static boolean exists(String url, int port, String user, String pwd, final String remoteDir, final String remoteFile) {
        return FTPUtil.execute(url, port, user, pwd, new IFTPExecutor<Boolean>(){

            @Override
            public Boolean execute(FTPClient client) throws Exception {
                String isoRemoteDir = new String(remoteDir.getBytes(LOCAL_CHARSET), REMOTE_CHARSET);
                FTPFile[] fs = client.listFiles(isoRemoteDir, new FTPFileFilter(){

                    public boolean accept(FTPFile file) {
                        String isoRemoteFile = new String(remoteFile.getBytes(LOCAL_CHARSET), REMOTE_CHARSET);
                        return file.getName().equals(isoRemoteFile);
                    }
                });
                return fs.length > 0;
            }
        });
    }

    public static void mkdirs(String url, int port, String user, String pwd, final String dir) {
        FTPUtil.execute(url, port, user, pwd, new IFTPExecutor<Void>(){

            @Override
            public Void execute(FTPClient client) throws Exception {
                String isoRemoteDir = new String(dir.getBytes(LOCAL_CHARSET), REMOTE_CHARSET);
                FTPUtil.mkdirs(client, isoRemoteDir);
                return null;
            }
        });
    }

    private static void mkdirs(FTPClient client, String dir) {
        String path = dir;
        if (!path.startsWith("/")) {
            throw new UnifyException("\u8def\u5f84\u65e0\u6548");
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String[] dirs = path.substring(1).split("/");
        String current = "/";
        try {
            for (int i = 0; i < dirs.length; ++i) {
                if (client.changeWorkingDirectory(current = current + dirs[i] + "/") || client.makeDirectory(current)) continue;
                throw new UnifySocketException("\u5728FTP\u4e0b\u521b\u5efa\u76ee\u5f55[" + path + "]\u5931\u8d25");
            }
        }
        catch (IOException e) {
            throw new UnifySocketException("\u5728FTP\u4e0b\u521b\u5efa\u76ee\u5f55[" + path + "]\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downLoop(FTPClient client, String remoteDir, String localDir, FTPConfig config, Pattern pattern) {
        String chsLocalDir = new String(localDir.getBytes(REMOTE_CHARSET), LOCAL_CHARSET);
        String chsRemoteDir = new String(remoteDir.getBytes(REMOTE_CHARSET), LOCAL_CHARSET);
        FileUtil.mkdir(chsLocalDir);
        FTPFile[] files = null;
        try {
            if (!client.changeWorkingDirectory(remoteDir)) {
                throw new UnifySocketException("\u83b7\u53d6FTP\u76ee\u5f55[" + chsRemoteDir + "]\u4e0b\u7684\u6587\u4ef6\u5931\u8d25");
            }
            files = client.listFiles();
        }
        catch (UnifyException e) {
            throw e;
        }
        catch (Exception err) {
            if (config.isIgnoreError()) {
                logger.warn("\u83b7\u53d6FTP\u76ee\u5f55[" + chsRemoteDir + "]\u4e0b\u7684\u6587\u4ef6\u5931\u8d25", (Throwable)err);
                return;
            }
            throw new UnifySocketException("\u83b7\u53d6FTP\u76ee\u5f55[" + chsRemoteDir + "]\u4e0b\u7684\u6587\u4ef6\u5931\u8d25", err);
        }
        if (files.length > 0) {
            for (FTPFile f : files) {
                String chsFName = new String(f.getName().getBytes(REMOTE_CHARSET), LOCAL_CHARSET);
                if (f.isDirectory() && config.isLoop()) {
                    FTPUtil.downLoop(client, remoteDir + "/" + f.getName(), localDir + File.separatorChar + f.getName(), config, pattern);
                    continue;
                }
                if (pattern != null && !pattern.matcher(chsFName).matches()) continue;
                File l = new File(chsLocalDir + File.separatorChar + chsFName);
                if (config.isIgnoreExists() && l.exists() && l.length() == f.getSize()) {
                    logger.debug("FTP\u6587\u4ef6[" + chsFName + "]\u5728\u672c\u5730\u5df2\u5b58\u5728\u4e14\u5927\u5c0f\u76f8\u540c\uff0c\u8df3\u8fc7\u4e0b\u8f7d");
                    continue;
                }
                FileOutputStream st = null;
                try {
                    st = new FileOutputStream(l);
                    if (client.retrieveFile(remoteDir + "/" + f.getName(), (OutputStream)st)) {
                        logger.debug("FTP\u6587\u4ef6[" + chsFName + "]\u4e0b\u8f7d\u5b8c\u6210");
                        continue;
                    }
                    if (config.isIgnoreError()) {
                        logger.debug("FTP\u6587\u4ef6[" + chsFName + "]\u4e0b\u8f7d\u5931\u8d25");
                        continue;
                    }
                    throw new UnifySocketException("FTP\u6587\u4ef6[" + chsFName + "]\u4e0b\u8f7d\u5931\u8d25");
                }
                catch (UnifyException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (config.isIgnoreError()) {
                        logger.warn("FTP\u6587\u4ef6[" + chsFName + "]\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                        continue;
                    }
                    throw new UnifySocketException("FTP\u6587\u4ef6[" + chsFName + "]\u4e0b\u8f7d\u5931\u8d25", e);
                }
                finally {
                    try {
                        ((OutputStream)st).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void upLoop(FTPClient client, String remoteDir, String localDir, FTPConfig config, Pattern pattern) {
        String isoRemoteDir = new String(remoteDir.getBytes(LOCAL_CHARSET), REMOTE_CHARSET);
        FTPUtil.mkdirs(client, isoRemoteDir);
        File file = new File(localDir);
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                if (f.isDirectory() && config.isLoop()) {
                    FTPUtil.upLoop(client, remoteDir + "/" + f.getName(), f.getPath(), config, pattern);
                    continue;
                }
                if (pattern != null && !pattern.matcher(f.getName()).matches()) continue;
                try {
                    final String isoFName = new String(f.getName().getBytes(LOCAL_CHARSET), REMOTE_CHARSET);
                    if (client.changeWorkingDirectory(isoRemoteDir)) {
                        FTPFile[] ftpFiles = client.listFiles(isoRemoteDir, new FTPFileFilter(){

                            public boolean accept(FTPFile file) {
                                return file.getName().equals(isoFName);
                            }
                        });
                        if (config.isIgnoreExists() && ftpFiles.length > 0 && ftpFiles[0].getSize() == f.length()) {
                            logger.debug("\u672c\u5730\u6587\u4ef6[" + f.getPath() + "]\u5728FTP\u76ee\u5f55[" + remoteDir + "]\u5df2\u5b58\u5728\u4e14\u5927\u5c0f\u76f8\u540c\uff0c\u8df3\u8fc7\u4e0a\u4f20");
                            continue;
                        }
                        FileInputStream fis = new FileInputStream(f);
                        try {
                            if (client.storeFile(isoFName, (InputStream)fis)) {
                                logger.debug("\u672c\u5730\u6587\u4ef6[" + f.getPath() + "]\u4e0a\u4f20\u5b8c\u6210");
                                continue;
                            }
                            if (config.isIgnoreError()) {
                                logger.debug("\u672c\u5730\u6587\u4ef6[" + f.getPath() + "]\u4e0a\u4f20\u5931\u8d25");
                                continue;
                            }
                            throw new UnifySocketException("\u672c\u5730\u6587\u4ef6[" + f.getPath() + "]\u4e0a\u4f20\u5931\u8d25");
                        }
                        catch (UnifyException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            if (config.isIgnoreError()) {
                                logger.debug("\u672c\u5730\u6587\u4ef6[" + f.getPath() + "]\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
                                continue;
                            }
                            throw new UnifySocketException("\u672c\u5730\u6587\u4ef6[" + f.getPath() + "]\u4e0a\u4f20\u5931\u8d25", e);
                        }
                        finally {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (config.isIgnoreError()) {
                        logger.warn("\u4e0a\u4f20\u6587\u4ef6[" + f.getPath() + "]\u5230FTP\u76ee\u5f55[" + remoteDir + "]\u5931\u8d25");
                        continue;
                    }
                    throw new UnifySocketException("\u4e0a\u4f20\u6587\u4ef6[" + f.getPath() + "]\u5230FTP\u76ee\u5f55[" + remoteDir + "]\u5931\u8d25");
                }
                catch (Exception e) {
                    if (config.isIgnoreError()) {
                        logger.warn("\u4e0a\u4f20\u6587\u4ef6[" + f.getPath() + "]\u5230FTP\u76ee\u5f55[" + remoteDir + "]\u5931\u8d25", (Throwable)e);
                        continue;
                    }
                    throw new UnifySocketException("\u4e0a\u4f20\u6587\u4ef6[" + f.getPath() + "]\u5230FTP\u76ee\u5f55[" + remoteDir + "]\u5931\u8d25", e);
                }
            }
        }
    }
}

