/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.StreamUtils;
import com.help.common.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static void zip(String srcRootDir, File file, ZipOutputStream zos) throws Exception {
        if (file == null) {
            return;
        }
        if (file.isFile()) {
            int count;
            int bufferLen = 1024;
            byte[] data = new byte[bufferLen];
            String subPath = file.getAbsolutePath();
            int index = subPath.indexOf(srcRootDir);
            if (index != -1) {
                subPath = subPath.substring(srcRootDir.length() + File.separator.length());
            }
            ZipEntry entry = new ZipEntry(subPath);
            zos.putNextEntry(entry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            while ((count = bis.read(data, 0, bufferLen)) != -1) {
                zos.write(data, 0, count);
            }
            bis.close();
            zos.closeEntry();
        } else {
            File[] childFileList = file.listFiles();
            for (int n = 0; n < childFileList.length; ++n) {
                childFileList[n].getAbsolutePath().indexOf(file.getAbsolutePath());
                ZipUtil.zip(srcRootDir, childFileList[n], zos);
            }
        }
    }

    public static byte[] zip(byte[] data) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(bos);
        ZipEntry entry = new ZipEntry("~tmp.xml");
        entry.setSize(data.length);
        try {
            zip.putNextEntry(entry);
            zip.write(data);
        }
        catch (IOException e) {
            throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "byte\u6570\u636e\u538b\u7f29\u5931\u8d25");
        }
        finally {
            try {
                zip.closeEntry();
            }
            catch (Exception exception) {}
            try {
                zip.close();
            }
            catch (IOException iOException) {}
        }
        return bos.toByteArray();
    }

    public static byte[] unZipFirst(byte[] data) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ZipInputStream zip = new ZipInputStream(bis);
        try {
            if (zip.getNextEntry() != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                StreamUtils.copy(zip, (OutputStream)baos);
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
            try {
                throw new UnifyException("byte\u538b\u7f29\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\u4efb\u4f55\u6587\u4ef6");
            }
            catch (UnifyException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UnifyException("byte\u6570\u636e\u89e3\u538b\u7f29\u5931\u8d25", (Throwable)e);
            }
        }
        finally {
            try {
                zip.close();
            }
            catch (IOException iOException) {}
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void zip(String srcPath, String zipPath, String zipFileName) throws Exception {
        if (StringUtil.isEmpty(srcPath) || StringUtil.isEmpty(zipPath) || StringUtil.isEmpty(zipFileName)) {
            throw new UnifyException("\u8def\u5f84\u53c2\u6570\u9519\u8bef");
        }
        CheckedOutputStream cos = null;
        ZipOutputStream zos = null;
        try {
            int index;
            String zipFilePath;
            File zipFile;
            File srcFile = new File(srcPath);
            if (srcFile.isDirectory() && zipPath.indexOf(srcPath) != -1) {
                throw new UnifyException("\u8def\u5f84\u53c2\u6570\u9519\u8bef");
            }
            File zipDir = new File(zipPath);
            if (!zipDir.exists() || !zipDir.isDirectory()) {
                zipDir.mkdirs();
            }
            if ((zipFile = new File(zipFilePath = zipPath + File.separator + zipFileName)).exists()) {
                SecurityManager securityManager = new SecurityManager();
                securityManager.checkDelete(zipFilePath);
                zipFile.delete();
            }
            cos = new CheckedOutputStream(new FileOutputStream(zipFile), new CRC32());
            zos = new ZipOutputStream(cos);
            String srcRootDir = srcPath;
            if (srcFile.isFile() && (index = srcPath.lastIndexOf(File.separator)) != -1) {
                srcRootDir = srcPath.substring(0, index);
            }
            ZipUtil.zip(srcRootDir, srcFile, zos);
            zos.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void unzip(String zipFilePath, String unzipFilePath, boolean includeZipFileName) throws Exception {
        File unzipFileDir;
        if (StringUtil.isEmpty(zipFilePath) || StringUtil.isEmpty(unzipFilePath)) {
            throw new UnifyException("\u8def\u5f84\u53c2\u6570\u9519\u8bef");
        }
        File zipFile = new File(zipFilePath);
        if (includeZipFileName) {
            String fileName = zipFile.getName();
            if (StringUtil.isNotEmpty(fileName)) {
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
            }
            unzipFilePath = unzipFilePath + File.separator + fileName;
        }
        if (!(unzipFileDir = new File(unzipFilePath)).exists() || !unzipFileDir.isDirectory()) {
            unzipFileDir.mkdirs();
        }
        ZipEntry entry = null;
        String entryFilePath = null;
        String entryDirPath = null;
        File entryFile = null;
        File entryDir = null;
        int index = 0;
        int count = 0;
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            entryFilePath = unzipFilePath + File.separator + entry.getName();
            index = entryFilePath.lastIndexOf(File.separator);
            entryDirPath = index != -1 ? entryFilePath.substring(0, index) : "";
            entryDir = new File(entryDirPath);
            if (!entryDir.exists() || !entryDir.isDirectory()) {
                entryDir.mkdirs();
            }
            if ((entryFile = new File(entryFilePath)).exists()) {
                SecurityManager securityManager = new SecurityManager();
                securityManager.checkDelete(entryFilePath);
                entryFile.delete();
            }
            bos = new BufferedOutputStream(new FileOutputStream(entryFile));
            bis = new BufferedInputStream(zip.getInputStream(entry));
            while ((count = bis.read(buffer, 0, bufferSize)) != -1) {
                bos.write(buffer, 0, count);
            }
            bos.flush();
            bos.close();
        }
    }
}

