/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util;

import com.help.common.util.intf.IFunction;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringUtil {
    private static final char DBC_CHAR_START = '!';
    private static final char DBC_CHAR_END = '~';
    private static final char SBC_CHAR_START = '\uff01';
    private static final char SBC_CHAR_END = '\uff5e';
    private static final int CONVERT_STEP = 65248;
    private static final char SBC_SPACE = '\u3000';
    private static final char DBC_SPACE = ' ';
    private static String[][] FilterChars = new String[][]{{"<", "&lt;"}, {">", "&gt;"}, {" ", "&nbsp;"}, {"\"", "&quot;"}, {"&", "&amp;"}, {"/", "&#47;"}, {"\\", "&#92;"}, {"\n", "<br>"}};

    private static String stringConnect(String[] strings, String spilit_sign) {
        String str = "";
        for (int i = 0; i < strings.length; ++i) {
            str = str + strings[i] + spilit_sign;
        }
        return str;
    }

    private static String[] stringSpilit(String str, String spilit_sign) {
        String[] spilit_string = str.split(spilit_sign);
        if (spilit_string[0].equals("")) {
            String[] new_string = new String[spilit_string.length - 1];
            for (int i = 1; i < spilit_string.length; ++i) {
                new_string[i - 1] = spilit_string[i];
            }
            return new_string;
        }
        return spilit_string;
    }

    public static String stringFilter(String str) {
        String[] str_arr = StringUtil.stringSpilit(str, "");
        for (int i = 0; i < str_arr.length; ++i) {
            for (int j = 0; j < FilterChars.length; ++j) {
                if (!FilterChars[j][0].equals(str_arr[i])) continue;
                str_arr[i] = FilterChars[j][1];
            }
        }
        return StringUtil.stringConnect(str_arr, "").trim();
    }

    public static String dbcToSbc(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str.length());
        char[] ca = str.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] >= '!' && ca[i] <= '~') {
                sb.append((char)(ca[i] + 65248));
                continue;
            }
            if (ca[i] == ' ') {
                sb.append('\u3000');
                continue;
            }
            sb.append(ca[i]);
        }
        return sb.toString();
    }

    public static String sbcToDbc(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str.length());
        char[] ca = str.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] >= '\uff01' && ca[i] <= '\uff5e') {
                sb.append((char)(ca[i] - 65248));
                continue;
            }
            if (ca[i] == '\u3000') {
                sb.append(' ');
                continue;
            }
            sb.append(ca[i]);
        }
        return sb.toString();
    }

    public static boolean contains(List<String> list1, List<String> list2) {
        for (String s2 : list2) {
            boolean contain = false;
            for (String s1 : list1) {
                if (!s1.equals(s2)) continue;
                contain = true;
                break;
            }
            if (contain) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(String[] arr1, String[] arr2) {
        return StringUtil.contains(Arrays.asList(arr1), Arrays.asList(arr2));
    }

    public static boolean containsAny(List<String> list1, List<String> list2) {
        for (String s2 : list2) {
            for (String s1 : list1) {
                if (!s1.equals(s2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(String[] arr1, String[] arr2) {
        return StringUtil.containsAny(Arrays.asList(arr1), Arrays.asList(arr2));
    }

    public static boolean splitContain(String listStr, String search) {
        return StringUtil.splitContain(listStr, search, ",");
    }

    public static boolean splitContain(String listStr, String search, String split) {
        String[] arr;
        if (listStr == null || listStr.length() == 0) {
            return false;
        }
        for (String str : arr = listStr.split(split)) {
            if (!search.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static String join(int[] arr, String split) {
        if (arr == null) {
            return "";
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int s : arr) {
            list.add(s);
        }
        return StringUtil.join(list, split);
    }

    public static String join(String[] arr, String split) {
        if (arr == null) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : arr) {
            list.add(s);
        }
        return StringUtil.join(list, split);
    }

    public static <T> String join(T[] arr, String split) {
        return StringUtil.join(Arrays.asList(arr), split);
    }

    public static <T> String join(T[] arr, String split, IFunction<T, String> convert) {
        return StringUtil.join(Arrays.asList(arr), split, convert);
    }

    public static <T> String join(Iterable<T> list, String split, IFunction<T, String> convert) {
        StringBuffer sb = new StringBuffer();
        for (T s : list) {
            sb.append(split);
            sb.append(convert.execute(s));
        }
        if (sb.length() > 0) {
            return sb.substring(split.length());
        }
        return "";
    }

    public static <T> String join(Iterable<T> list, String split) {
        return StringUtil.join(list, split, (T p) -> p.toString());
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        return StringUtil.isEmpty(obj.toString());
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isNotEmpty(Object obj) {
        if (obj == null) {
            return false;
        }
        return StringUtil.isNotEmpty(obj.toString());
    }

    public static boolean isEmptyAll(List<String> strs) {
        if (strs == null) {
            return true;
        }
        for (String s : strs) {
            if (!StringUtil.isNotEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyAll(String ... strs) {
        if (strs == null) {
            return true;
        }
        return StringUtil.isEmptyAll(Arrays.asList(strs));
    }

    public static boolean isEmptyAny(List<String> strs) {
        if (strs == null) {
            return true;
        }
        for (String s : strs) {
            if (!StringUtil.isEmpty(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyAny(String ... strs) {
        if (strs == null) {
            return true;
        }
        return StringUtil.isEmptyAny(Arrays.asList(strs));
    }

    public static boolean isNotEmptyAll(List<String> strs) {
        if (strs == null) {
            return false;
        }
        for (String s : strs) {
            if (!StringUtil.isEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmptyAll(String ... strs) {
        if (strs == null) {
            return false;
        }
        return StringUtil.isNotEmptyAll(Arrays.asList(strs));
    }

    public static boolean isNotEmptyAny(List<String> strs) {
        if (strs == null) {
            return false;
        }
        for (String s : strs) {
            if (!StringUtil.isNotEmpty(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotEmptyAny(String ... strs) {
        if (strs == null) {
            return false;
        }
        return StringUtil.isNotEmptyAny(Arrays.asList(strs));
    }

    public static String nvl(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        return str;
    }

    public static String nvl(String str, String value) {
        if (str == null || str.isEmpty()) {
            return value;
        }
        return str;
    }

    public static String nvl(Object obj) {
        if (obj == null || obj.toString().isEmpty()) {
            return null;
        }
        return obj.toString();
    }

    public static String nvl(Object obj, String value) {
        if (obj == null || obj.toString().isEmpty()) {
            return value;
        }
        return obj.toString();
    }

    public static Charset guessEncoding(byte[] data) {
        String[] encodes;
        if (data.length > 4096) {
            data = Arrays.copyOfRange(data, 0, 4096);
        }
        for (String enc : encodes = new String[]{"utf-8", "gbk", "gb2312", "unicode"}) {
            for (int i = 0; i < 4; ++i) {
                byte[] tmp = Arrays.copyOfRange(data, 0, data.length - i);
                try {
                    if (!StringUtil.t(tmp, enc)) continue;
                    return Charset.forName(enc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static boolean t(byte[] data, String encode) throws UnsupportedEncodingException {
        String str = new String(data, encode);
        byte[] data2 = str.getBytes(encode);
        return Arrays.equals(data, data2);
    }
}

