/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util;

import com.help.common.util.Security;
import com.help.common.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SignUtil {
    private static ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal();

    private static SimpleDateFormat getDateFormat() {
        SimpleDateFormat df = threadLocal.get();
        if (df == null) {
            df = new SimpleDateFormat("yyyyMMddHHmmss", Locale.CHINA);
            threadLocal.set(df);
        }
        return df;
    }

    public static boolean validate(Map<String, String> map, String token) {
        String clientId = map.get("clientId");
        String timeStr = map.get("signTime");
        String sign = map.get("sign");
        if (StringUtil.isEmpty(clientId) || StringUtil.isEmpty(timeStr) || StringUtil.isEmpty(sign)) {
            return false;
        }
        HashMap<String, String> tmp = new HashMap<String, String>();
        for (Map.Entry<String, String> kv : map.entrySet()) {
            if ("sign".equals(kv.getKey())) continue;
            tmp.put(kv.getKey().toLowerCase(), kv.getValue());
        }
        try {
            Date time = SignUtil.getDateFormat().parse(timeStr);
            return sign.equalsIgnoreCase(SignUtil.sign(tmp, clientId, token, time));
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static String sign(Map<String, String> map, String clientId, String key, Date date) {
        HashMap<String, String> tmp = new HashMap<String, String>();
        for (Map.Entry<String, String> kv : map.entrySet()) {
            if ("sign".equals(kv.getKey()) || !StringUtil.isNotEmpty(kv.getValue())) continue;
            tmp.put(kv.getKey().toLowerCase(), kv.getValue().trim());
        }
        tmp.put("clientid", clientId);
        tmp.put("signtime", SignUtil.getDateFormat().format(date));
        Object[] keys = tmp.keySet().toArray(new String[tmp.size()]);
        Arrays.sort(keys);
        StringBuffer sb = new StringBuffer();
        for (Object k : keys) {
            String value = (String)tmp.get(k);
            sb.append("&");
            sb.append(((String)k).toLowerCase());
            sb.append("=");
            sb.append(value);
        }
        sb.append("&");
        sb.append(key);
        return Security.toSHA1(sb.substring(1)).toUpperCase();
    }
}

