/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.SM3Digest;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class Security {
    private static ThreadLocal<Map<String, Cipher>> rsaEncryptCipherThreadLocal = new ThreadLocal();
    private static ThreadLocal<Map<String, Cipher>> rsaDecryptCipherThreadLocal = new ThreadLocal();
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();

    private static Map<String, Cipher> getEncryptCipherMap() {
        Map<String, Cipher> df = rsaEncryptCipherThreadLocal.get();
        if (df == null) {
            df = new HashMap<String, Cipher>();
            rsaEncryptCipherThreadLocal.set(df);
        }
        return df;
    }

    private static Map<String, Cipher> getDecryptCipherMap() {
        Map<String, Cipher> df = rsaDecryptCipherThreadLocal.get();
        if (df == null) {
            df = new HashMap<String, Cipher>();
            rsaDecryptCipherThreadLocal.set(df);
        }
        return df;
    }

    private static Cipher getRsaPubKeyCipher(String key) throws Exception {
        KeyFactory keyf = KeyFactory.getInstance("RSA");
        key = key.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replace(" ", "").replace("\r", "").replace("\n", "");
        Map<String, Cipher> map = Security.getEncryptCipherMap();
        if (map.containsKey(key)) {
            return map.get(key);
        }
        byte[] data = Base64.getDecoder().decode(key);
        PublicKey k = keyf.generatePublic(new X509EncodedKeySpec(data));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, k);
        map.put(key, cipher);
        return cipher;
    }

    private static Cipher getRsaPrivateKeyCipher(String key) throws Exception {
        KeyFactory keyf = KeyFactory.getInstance("RSA");
        key = key.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace(" ", "").replace("\r", "").replace("\n", "");
        Map<String, Cipher> map = Security.getDecryptCipherMap();
        if (map.containsKey(key)) {
            return map.get(key);
        }
        byte[] data = Base64.getDecoder().decode(key);
        PrivateKey k = keyf.generatePrivate(new PKCS8EncodedKeySpec(data));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, k);
        map.put(key, cipher);
        return cipher;
    }

    public static byte[] rsaEncrypt(byte[] data, String pubKey) {
        try {
            return Security.getRsaPubKeyCipher(pubKey).doFinal(data);
        }
        catch (Exception e) {
            throw new UnifyException("\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
        }
    }

    public static byte[] rsaDecrypt(byte[] data, String priKey) {
        try {
            return Security.getRsaPrivateKeyCipher(priKey).doFinal(data);
        }
        catch (Exception e) {
            throw new UnifyException("\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
        }
    }

    private static String sha(String decript, String type, String encoding) {
        try {
            MessageDigest digest = MessageDigest.getInstance(type);
            digest.update(decript.getBytes(encoding));
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u6570\u636e\u8f6cSHA\u5931\u8d25");
        }
    }

    public static String toMD5(String str) {
        return Security.toMD5(str, "utf-8");
    }

    public static String toMD5(String str, String charset) {
        try {
            byte[] arr = MessageDigest.getInstance("MD5").digest(str.getBytes(charset));
            return Security.byteArrayToHexString(arr);
        }
        catch (Exception e) {
            throw new UnifyException("\u83b7\u53d6\u5b57\u7b26\u4e32[" + str + "]\u7684MD5\u5931\u8d25");
        }
    }

    public static String toSHA1(String str) {
        return Security.sha(str, "SHA-1", "utf-8");
    }

    public static String toSHA1(String str, String charset) {
        return Security.sha(str, "SHA-1", charset);
    }

    public static String toSHA256(String str) {
        return Security.sha(str, "SHA-256", "utf-8");
    }

    public static String toSHA256(String str, String charset) {
        return Security.sha(str, "SHA-256", charset);
    }

    public static String toSHA512(String str) {
        return Security.sha(str, "SHA-512", "utf-8");
    }

    public static String toSHA512(String str, String charset) {
        return Security.sha(str, "SHA-512", charset);
    }

    public static String toSM3(String data) {
        SM3Digest digest = new SM3Digest();
        try {
            digest.update(data.getBytes("utf-8"), 0, data.getBytes("utf-8").length);
            byte[] out = new byte[32];
            digest.doFinal(out, 0);
            return Security.byteArrayToHexString(out);
        }
        catch (Exception e) {
            throw new UnifyException("SM3\u52a0\u5bc6\u5931\u8d25");
        }
    }

    public static String toBase64(String str) {
        return Security.toBase64(str.getBytes());
    }

    public static String toBase64(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return new String(out);
    }

    public static byte[] hexStringToByteArray(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(Security.charToByte(hexChars[pos]) << 4 | Security.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(Security.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }
}

