/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util;

import com.help.common.util.SM3;
import com.help.common.util.Util;
import java.math.BigInteger;

public class SM3Digest {
    private static final int BYTE_LENGTH = 32;
    private static final int BLOCK_LENGTH = 64;
    private static final int BUFFER_LENGTH = 128;
    private byte[] xBuf = new byte[128];
    private int xBufOff;
    private byte[] V = SM3.iv;
    private int cntBlock = 0;

    public int doFinal(byte[] out, int outOff) {
        byte[] tmp = this.doFinal();
        System.arraycopy(tmp, 0, out, 0, tmp.length);
        return 32;
    }

    public String getAlgorithmName() {
        return "SM3";
    }

    public int getDigestSize() {
        return 32;
    }

    public void reset() {
        this.xBufOff = 0;
        this.cntBlock = 0;
        this.V = SM3.iv;
    }

    public void update(byte[] in, int inOff, int len) {
        if (this.xBufOff + len > 128) {
            int tmpLen = this.xBufOff + len - 128;
            System.arraycopy(in, inOff, this.xBuf, this.xBufOff, 128 - this.xBufOff);
            this.doUpdate();
            this.xBufOff = 0;
            int i = 1;
            while (tmpLen > 128) {
                tmpLen -= 128;
                System.arraycopy(in, inOff + 128 * i, this.xBuf, this.xBufOff, 128 - this.xBufOff);
                this.doUpdate();
                this.xBufOff = 0;
                ++i;
            }
            System.arraycopy(in, inOff + len - tmpLen, this.xBuf, this.xBufOff, tmpLen);
            this.xBufOff += tmpLen;
        } else if (this.xBufOff + len == 128) {
            System.arraycopy(in, inOff, this.xBuf, this.xBufOff, len);
            this.doUpdate();
            this.xBufOff = 0;
        } else {
            System.arraycopy(in, inOff, this.xBuf, this.xBufOff, len);
            this.xBufOff += len;
        }
    }

    private void doUpdate() {
        byte[] B = new byte[64];
        for (int i = 0; i < 128; i += 64) {
            System.arraycopy(this.xBuf, i, B, 0, B.length);
            this.doHash(B);
        }
        this.cntBlock += 2;
    }

    private void doHash(byte[] B) {
        this.V = SM3.CF(this.V, B);
    }

    private byte[] doFinal() {
        byte[] B = new byte[64];
        byte[] buffer = new byte[this.xBufOff];
        System.arraycopy(this.xBuf, 0, buffer, 0, buffer.length);
        byte[] tmp = SM3.padding(buffer, this.cntBlock);
        for (int i = 0; i < tmp.length; i += 64) {
            System.arraycopy(tmp, i, B, 0, B.length);
            this.doHash(B);
            ++this.cntBlock;
        }
        return this.V;
    }

    private byte[] getSM2Za(byte[] x, byte[] y, byte[] id) {
        byte[] tmp = Util.IntToByte(id.length * 8);
        byte[] buffer = new byte[194 + id.length];
        buffer[0] = tmp[1];
        buffer[1] = tmp[0];
        byte[] a = Util.getA();
        byte[] b = Util.getB();
        byte[] gx = Util.getGx();
        byte[] gy = Util.getGy();
        int dPos = 2;
        System.arraycopy(id, 0, buffer, dPos, id.length);
        System.arraycopy(a, 0, buffer, dPos += id.length, 32);
        System.arraycopy(b, 0, buffer, dPos += 32, 32);
        System.arraycopy(gx, 0, buffer, dPos += 32, 32);
        System.out.println(dPos += 32);
        System.arraycopy(gy, 0, buffer, dPos, 32);
        System.arraycopy(x, 0, buffer, dPos += 32, 32);
        System.arraycopy(y, 0, buffer, dPos += 32, 32);
        dPos += 32;
        SM3Digest digest = new SM3Digest();
        digest.update(buffer, 0, buffer.length);
        byte[] out = new byte[32];
        digest.doFinal(out, 0);
        return out;
    }

    public void addId(BigInteger affineX, BigInteger affineY, byte[] id) {
        byte[] x = Util.asUnsigned32ByteArray(affineX);
        byte[] y = Util.asUnsigned32ByteArray(affineY);
        byte[] tmp = this.getSM2Za(x, y, id);
        this.reset();
        System.arraycopy(tmp, 0, this.xBuf, this.xBufOff, 32);
        this.xBufOff = 32;
    }
}

