/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeUtil {
    private static final Logger log = LoggerFactory.getLogger(MimeUtil.class);
    public static final String MIMETYPE_XML = "application/xml";
    public static final String MIMETYPE_HTML = "text/html";
    public static final String MIMETYPE_OCTET_STREAM = "application/octet-stream";
    public static final String MIMETYPE_GZIP = "application/x-gzip";
    private static MimeUtil mimetypes = null;
    private static HashMap<String, String> extensionToMimetypeMap = new HashMap();

    private MimeUtil() {
    }

    public static String getMimetype(String fileName) {
        int lastPeriodIndex = fileName.lastIndexOf(".");
        if (lastPeriodIndex > 0 && lastPeriodIndex + 1 < fileName.length()) {
            String ext = fileName.substring(lastPeriodIndex + 1).toLowerCase();
            if (extensionToMimetypeMap.keySet().contains(ext)) {
                return extensionToMimetypeMap.get(ext);
            }
        }
        return MIMETYPE_OCTET_STREAM;
    }

    public static String getMimetype(File file) {
        return MimeUtil.getMimetype(file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        mimetypes = new MimeUtil();
        InputStream is = mimetypes.getClass().getResourceAsStream("/mime.types");
        if (is != null) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));){
                String line = null;
                while ((line = br.readLine()) != null) {
                    StringTokenizer st;
                    if ((line = line.trim()).startsWith("#") || line.length() == 0 || (st = new StringTokenizer(line, " \t")).countTokens() <= 1) continue;
                    String mimetype = st.nextToken();
                    while (st.hasMoreTokens()) {
                        String extension = st.nextToken();
                        extensionToMimetypeMap.put(extension.toLowerCase(), mimetype);
                    }
                }
            }
            catch (IOException ex) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    log.debug("", (Throwable)ex);
                }
            }
        }
    }
}

