/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util;

import com.help.common.util.intf.IFunction;
import com.help.common.util.intf.IPredicate;
import com.help.common.util.intf.IQueryable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LinqUtil {
    public static <T> IQueryable<T> toQueryable(Iterable<T> collection) {
        Queryable<T> query = new Queryable<T>(collection);
        return query;
    }

    public static IQueryable<Integer> toQueryable(int[] arr) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : arr) {
            list.add(i);
        }
        Queryable<Integer> query = new Queryable<Integer>(list);
        return query;
    }

    public static IQueryable<Short> toQueryable(short[] arr) {
        ArrayList<Short> list = new ArrayList<Short>();
        for (short i : arr) {
            list.add(i);
        }
        Queryable<Short> query = new Queryable<Short>(list);
        return query;
    }

    public static IQueryable<Long> toQueryable(long[] arr) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (long i : arr) {
            list.add(i);
        }
        Queryable<Long> query = new Queryable<Long>(list);
        return query;
    }

    public static IQueryable<Byte> toQueryable(byte[] arr) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (byte i : arr) {
            list.add(i);
        }
        Queryable<Byte> query = new Queryable<Byte>(list);
        return query;
    }

    public static IQueryable<Boolean> toQueryable(boolean[] arr) {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (boolean i : arr) {
            list.add(i);
        }
        Queryable<Boolean> query = new Queryable<Boolean>(list);
        return query;
    }

    public static IQueryable<Float> toQueryable(float[] arr) {
        ArrayList<Float> list = new ArrayList<Float>();
        for (float i : arr) {
            list.add(Float.valueOf(i));
        }
        Queryable<Float> query = new Queryable<Float>(list);
        return query;
    }

    public static IQueryable<Double> toQueryable(double[] arr) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (double i : arr) {
            list.add(i);
        }
        Queryable<Double> query = new Queryable<Double>(list);
        return query;
    }

    private static class Queryable<T>
    implements IQueryable<T> {
        private Iterable<T> collection;
        private List<IPredicate<T>> predicates;

        public Queryable(Iterable<T> collection) {
            this.collection = collection;
            this.predicates = new ArrayList<IPredicate<T>>();
        }

        public Queryable(Queryable<T> query, IPredicate<T> predicate) {
            this.collection = query.collection;
            this.predicates = new ArrayList<IPredicate<T>>(query.predicates);
            this.predicates.add(predicate);
        }

        @Override
        public boolean contains(IPredicate<T> predicate) {
            return this.firstOrDefault(predicate) != null;
        }

        @Override
        public T firstOrDefault() {
            for (T t : this.collection) {
                boolean allMatch = true;
                for (IPredicate<T> p : this.predicates) {
                    if (p.isMatch(t)) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                return t;
            }
            return null;
        }

        @Override
        public T firstOrDefault(IPredicate<T> predicate) {
            for (T t : this.collection) {
                if (!predicate.isMatch(t)) continue;
                boolean allMatch = true;
                for (IPredicate<T> p : this.predicates) {
                    if (p.isMatch(t)) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                return t;
            }
            return null;
        }

        @Override
        public T first() {
            T t = this.firstOrDefault();
            if (t == null) {
                throw new RuntimeException("\u65e0\u6cd5\u627e\u5230\u6307\u5b9a\u5bf9\u8c61");
            }
            return t;
        }

        @Override
        public T first(IPredicate<T> predicate) {
            T t = this.firstOrDefault(predicate);
            if (t == null) {
                throw new RuntimeException("\u65e0\u6cd5\u627e\u5230\u6307\u5b9a\u5bf9\u8c61");
            }
            return t;
        }

        @Override
        public T lastOrDefault() {
            T result = null;
            for (T t : this.collection) {
                boolean allMatch = true;
                for (IPredicate<T> p : this.predicates) {
                    if (p.isMatch(t)) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                result = t;
            }
            return result;
        }

        @Override
        public T lastOrDefault(IPredicate<T> predicate) {
            T result = null;
            for (T t : this.collection) {
                if (!predicate.isMatch(t)) continue;
                boolean allMatch = true;
                for (IPredicate<T> p : this.predicates) {
                    if (p.isMatch(t)) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                result = t;
            }
            return result;
        }

        @Override
        public T last() {
            T t = this.lastOrDefault();
            if (t == null) {
                throw new RuntimeException("\u65e0\u6cd5\u627e\u5230\u6307\u5b9a\u5bf9\u8c61");
            }
            return t;
        }

        @Override
        public T last(IPredicate<T> predicate) {
            T t = this.lastOrDefault(predicate);
            if (t == null) {
                throw new RuntimeException("\u65e0\u6cd5\u627e\u5230\u6307\u5b9a\u5bf9\u8c61");
            }
            return t;
        }

        @Override
        public IQueryable<T> where(IPredicate<T> predicate) {
            return new Queryable<T>(this, predicate);
        }

        @Override
        public int count() {
            int count = 0;
            for (T t : this.collection) {
                boolean allMatch = true;
                for (IPredicate<T> p : this.predicates) {
                    if (p.isMatch(t)) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                ++count;
            }
            return count;
        }

        @Override
        public int count(IPredicate<T> predicate) {
            int count = 0;
            for (T t : this.collection) {
                if (!predicate.isMatch(t)) continue;
                boolean allMatch = true;
                for (IPredicate<T> p : this.predicates) {
                    if (p.isMatch(t)) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                ++count;
            }
            return count;
        }

        @Override
        public List<T> toList() {
            ArrayList<T> list = new ArrayList<T>();
            for (T t : this.collection) {
                boolean allMatch = true;
                for (IPredicate<T> p : this.predicates) {
                    if (p.isMatch(t)) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                list.add(t);
            }
            return list;
        }

        @Override
        public <TResult> IQueryable<TResult> select(IFunction<T, TResult> parseFunction) {
            ArrayList<TResult> list = new ArrayList<TResult>();
            for (T t : this.collection) {
                boolean allMatch = true;
                for (IPredicate<T> p : this.predicates) {
                    if (p.isMatch(t)) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                list.add(parseFunction.execute(t));
            }
            return new Queryable(list);
        }

        @Override
        public T[] toArray(T[] array) {
            return this.toList().toArray(array);
        }

        @Override
        public Iterator<T> iterator() {
            return this.toList().iterator();
        }
    }
}

