/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util;

import com.help.common.exception.UnifyException;
import com.help.common.util.StringUtil;
import com.help.common.util.intf.IAction;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class FileUtil {
    public static boolean exists(String file) {
        return new File(file).exists();
    }

    public static File[] listFilesLoop(String path) {
        final ArrayList list = new ArrayList();
        IAction<File> fetch = new IAction<File>(){

            @Override
            public void execute(File t) {
                if (t.isDirectory()) {
                    File[] childs;
                    for (File f : childs = t.listFiles()) {
                        this.execute(f);
                    }
                } else {
                    list.add(t);
                }
            }
        };
        File file = new File(path);
        fetch.execute(file);
        return list.toArray(new File[list.size()]);
    }

    public static boolean isDirectory(String path) {
        File file = new File(path);
        return file.isDirectory();
    }

    public static File mkdir(String path) {
        File file = new File(path);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        return file;
    }

    public static void delete(String file) {
        File dir = new File(file);
        FileUtil.delete(dir);
    }

    public static void delete(File file) {
        if (file.exists()) {
            if (!file.isDirectory()) {
                file.delete();
            } else {
                IAction<File[]> del = new IAction<File[]>(){

                    @Override
                    public void execute(File[] t) {
                        for (File f : t) {
                            if (f.isDirectory()) {
                                this.execute(f.listFiles());
                                f.delete();
                                continue;
                            }
                            f.delete();
                        }
                    }
                };
                del.execute(new File[]{file});
            }
        }
    }

    public static String read(String fileName) {
        return FileUtil.read(fileName, "utf-8");
    }

    public static String read(String fileName, String encoding) {
        try {
            FileInputStream fis = new FileInputStream(fileName);
            return FileUtil.read(fis, encoding, true);
        }
        catch (FileNotFoundException e) {
            throw new UnifyException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25,\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)e);
        }
    }

    public static String read(InputStream is) {
        return FileUtil.read(is, false);
    }

    public static String read(InputStream is, boolean autoClose) {
        return FileUtil.read(is, "utf-8", autoClose);
    }

    public static String read(InputStream is, String encoding, boolean autoClose) {
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(is, encoding);
            br = new BufferedReader(isr);
            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new UnifyException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (autoClose) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException iOException) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void write(String str, String fileName) {
        FileUtil.write(str, fileName, "utf-8");
    }

    public static void write(String str, String fileName, String encoding) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(fileName, false);
            osw = new OutputStreamWriter((OutputStream)fos, encoding);
            bw = new BufferedWriter(osw);
            bw.write(str);
            bw.flush();
        }
        catch (Exception e) {
            throw new UnifyException("\u5199\u5165\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void thumbnailImage(String imagePath, String formatImagePath, int w, int h) {
        if (StringUtil.isNotEmpty(imagePath)) {
            File imgFile = new File(imagePath);
            try {
                BufferedImage img = ImageIO.read(imgFile);
                BufferedImage bi = new BufferedImage(w, h, 1);
                Graphics g = bi.getGraphics();
                g.drawImage(img, 0, 0, w, h, Color.LIGHT_GRAY, null);
                g.dispose();
                ImageIO.write((RenderedImage)bi, "jpg", new File(formatImagePath));
            }
            catch (IOException e) {
                throw new UnifyException("\u7f29\u7565\u56fe\u751f\u6210\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static void thumbnailImageLimitMax(String imagePath, String formatImagePath, int w, int h) {
        if (StringUtil.isNotEmpty(imagePath)) {
            File imgFile = new File(imagePath);
            try {
                BufferedImage img = ImageIO.read(imgFile);
                int width = ((Image)img).getWidth(null);
                int height = ((Image)img).getHeight(null);
                if ((double)width * 1.0 / (double)w < (double)height * 1.0 / (double)h) {
                    w = Integer.parseInt(new DecimalFormat("0").format((double)(width * h) / ((double)height * 1.0)));
                } else {
                    h = Integer.parseInt(new DecimalFormat("0").format((double)(height * w) / ((double)width * 1.0)));
                }
                BufferedImage bi = new BufferedImage(w, h, 1);
                Graphics g = bi.getGraphics();
                g.drawImage(img, 0, 0, w, h, Color.LIGHT_GRAY, null);
                g.dispose();
                ImageIO.write((RenderedImage)bi, "jpg", new File(formatImagePath));
            }
            catch (IOException e) {
                throw new UnifyException("\u7f29\u7565\u56fe\u751f\u6210\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

