/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Convert {
    private static String defaultDateFormatString;
    private static ThreadLocal<SimpleDateFormat> defaultDateFormatThreadLocal;

    private static SimpleDateFormat getDefaultDateFormat() {
        SimpleDateFormat df = defaultDateFormatThreadLocal.get();
        if (df == null) {
            df = new SimpleDateFormat(defaultDateFormatString, Locale.CHINA);
            defaultDateFormatThreadLocal.set(df);
        }
        return df;
    }

    public static BigDecimal toBigDecimal(String number) {
        return new BigDecimal(number);
    }

    public static BigDecimal toBigDecimal(String number, BigDecimal nvl) {
        if (number == null) {
            return nvl;
        }
        try {
            return new BigDecimal(number);
        }
        catch (Exception e) {
            return nvl;
        }
    }

    public static BigDecimal toBigDecimal(Object number) {
        if (number != null && number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return Convert.toBigDecimal(Convert.toString(number));
    }

    public static BigDecimal toBigDecimal(Object number, BigDecimal nvl) {
        if (number != null && number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return Convert.toBigDecimal(Convert.toString(number, null), nvl);
    }

    public static double toDouble(String value) {
        return Double.parseDouble(value);
    }

    public static double toDouble(String value, double nvl) {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception err) {
            return nvl;
        }
    }

    public static double toDouble(Object value) {
        if (value == null) {
            throw new NullPointerException("\u65e0\u6cd5\u5c06null\u8f6c\u6362\u4e3aDouble");
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof String) {
            return Convert.toDouble((String)value);
        }
        throw new ClassCastException("\u65e0\u6cd5\u5c06\u7c7b\u578b" + value.getClass().getName() + "\u8f6c\u6362\u4e3aDouble");
    }

    public static double toDouble(Object value, double nvl) {
        try {
            return Convert.toDouble(value);
        }
        catch (Exception err) {
            return nvl;
        }
    }

    public static long toLong(String value) {
        return (long)Double.parseDouble(value);
    }

    public static long toLong(String value, long nvl) {
        try {
            return Convert.toLong(value);
        }
        catch (Exception err) {
            return nvl;
        }
    }

    public static long toLong(Object value) {
        if (value == null) {
            throw new NullPointerException("\u65e0\u6cd5\u5c06null\u8f6c\u6362\u4e3aLong");
        }
        if (value instanceof Double) {
            double tmp = (Double)value;
            return (long)tmp;
        }
        if (value instanceof Float) {
            float tmp = ((Float)value).floatValue();
            return (long)tmp;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof String) {
            return Convert.toLong((String)value);
        }
        throw new ClassCastException("\u65e0\u6cd5\u5c06\u7c7b\u578b" + value.getClass().getName() + "\u8f6c\u6362\u4e3aLong");
    }

    public static long toLong(Object value, long nvl) {
        try {
            return Convert.toLong(value);
        }
        catch (Exception err) {
            return nvl;
        }
    }

    public static int toInt(String value) {
        return (int)Convert.toDouble(value);
    }

    public static int toInt(String value, int nvl) {
        try {
            return Convert.toInt(value);
        }
        catch (Exception err) {
            return nvl;
        }
    }

    public static int toInt(Object value) {
        if (value == null) {
            throw new NullPointerException("\u65e0\u6cd5\u5c06null\u8f6c\u6362\u4e3aInteger");
        }
        if (value instanceof Double) {
            double tmp = (Double)value;
            return (int)tmp;
        }
        if (value instanceof Float) {
            float tmp = ((Float)value).floatValue();
            return (int)tmp;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            long tmp = (Long)value;
            return (int)tmp;
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof String) {
            return Convert.toInt((String)value);
        }
        throw new ClassCastException("\u65e0\u6cd5\u5c06\u7c7b\u578b" + value.getClass().getName() + "\u8f6c\u6362\u4e3aInteger");
    }

    public static int toInt(Object value, int nvl) {
        try {
            return Convert.toInt(value);
        }
        catch (Exception err) {
            return nvl;
        }
    }

    public static String toString(long number) {
        return String.valueOf(number);
    }

    public static String toString(double number) {
        return new DecimalFormat("0.00").format(number);
    }

    public static String toString(double number, String format) {
        return new DecimalFormat(format).format(number);
    }

    public static String toString(Date obj) {
        return Convert.toString(obj, "yyyy-MM-dd HH:mm:ss");
    }

    public static String toString(Object obj) {
        return Convert.toString(obj, null);
    }

    public static String toString(Object obj, String nvl) {
        if (obj != null) {
            return String.valueOf(obj);
        }
        return nvl;
    }

    public static String toMoneyString(long number) {
        return Convert.toMoneyString((double)number);
    }

    public static String toMoneyString(BigDecimal number) {
        if (number != null) {
            return Convert.toMoneyString(number.doubleValue());
        }
        throw new NullPointerException("\u65e0\u6cd5\u5c06null\u8f6c\u6362\u4e3aMoney");
    }

    public static String toMoneyString(BigDecimal number, String nvl) {
        if (number != null) {
            return Convert.toMoneyString(number.doubleValue());
        }
        return nvl;
    }

    public static String toMoneyString(double number) {
        return new DecimalFormat(",###.##").format(number);
    }

    public static Date toDate(String dateString, String format) {
        try {
            if (format == null || defaultDateFormatString.equals(format)) {
                return Convert.getDefaultDateFormat().parse(dateString);
            }
            return new SimpleDateFormat(format, Locale.CHINA).parse(dateString);
        }
        catch (ParseException e) {
            throw new ClassCastException("\u65e0\u6cd5\u5c06\u5b57\u7b26\u4e32" + dateString + "\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
        }
    }

    public static Date toDate(String dateString, String format, Date nvl) {
        try {
            if (format == null || defaultDateFormatString.equals(format)) {
                return Convert.getDefaultDateFormat().parse(dateString);
            }
            return new SimpleDateFormat(format, Locale.CHINA).parse(dateString);
        }
        catch (ParseException e) {
            return nvl;
        }
    }

    public static String toString(Date date, String format) {
        if (format == null || defaultDateFormatString.equals(format)) {
            return Convert.getDefaultDateFormat().format(date);
        }
        return new SimpleDateFormat(format, Locale.CHINA).format(date);
    }

    public static String toString(Date date, String format, String nvl) {
        try {
            return Convert.toString(date, format);
        }
        catch (Exception err) {
            return nvl;
        }
    }

    public static String dateFormat(String dateStr, String strformat, String targetFormat) {
        Date date = Convert.toDate(dateStr, strformat);
        String formatDate = Convert.toString(date, targetFormat);
        return formatDate;
    }

    static {
        defaultDateFormatThreadLocal = new ThreadLocal();
        defaultDateFormatString = "yyyy-MM-dd";
    }
}

