/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util;

import com.help.common.util.intf.IPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CollectionUtil {
    public static <T> boolean contains(Iterable<T> collection, IPredicate<T> predicate) {
        return CollectionUtil.firstOrDefault(collection, predicate) != null;
    }

    public static <T> T firstOrDefault(Iterable<T> collection, IPredicate<T> predicate) {
        for (T t : collection) {
            if (!predicate.isMatch(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> T first(Iterable<T> collection, IPredicate<T> predicate) {
        T t = CollectionUtil.firstOrDefault(collection, predicate);
        if (t == null) {
            throw new RuntimeException("\u65e0\u6cd5\u627e\u5230\u6307\u5b9a\u5bf9\u8c61");
        }
        return t;
    }

    public static <T> T lastOrDefault(Iterable<T> collection, IPredicate<T> predicate) {
        T find = null;
        for (T t : collection) {
            if (!predicate.isMatch(t)) continue;
            find = t;
        }
        return find;
    }

    public static <T> T last(Iterable<T> collection, IPredicate<T> predicate) {
        T t = CollectionUtil.lastOrDefault(collection, predicate);
        if (t == null) {
            throw new RuntimeException("\u65e0\u6cd5\u627e\u5230\u6307\u5b9a\u5bf9\u8c61");
        }
        return t;
    }

    public static <T> Collection<T> findAll(Iterable<T> collection, IPredicate<T> predicate) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : collection) {
            if (!predicate.isMatch(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> int count(Iterable<T> collection, IPredicate<T> predicate) {
        int count = 0;
        for (T t : collection) {
            if (!predicate.isMatch(t)) continue;
            ++count;
        }
        return count;
    }

    public static <T> void delete(Iterable<T> collection, IPredicate<T> predicate) {
        Iterator<T> it = collection.iterator();
        while (it.hasNext()) {
            T t = it.next();
            if (!predicate.isMatch(t)) continue;
            it.remove();
        }
    }
}

