/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.help.common.UnifyPageData;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.ArraysUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BeanConvert {
    private static final ObjectMapper MAPPER = BeanConvert.newObjectMapper();

    public static SimpleModule newSimpleModule() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Integer.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Integer.TYPE, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Double.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Double.TYPE, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(BigDecimal.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addDeserializer(Integer.class, (JsonDeserializer)new NumberDeserializers.IntegerDeserializer(Integer.class, null));
        simpleModule.addDeserializer(Integer.TYPE, (JsonDeserializer)new NumberDeserializers.IntegerDeserializer(Integer.class, null));
        simpleModule.addDeserializer(Long.class, (JsonDeserializer)new NumberDeserializers.LongDeserializer(Long.class, null));
        simpleModule.addDeserializer(Long.TYPE, (JsonDeserializer)new NumberDeserializers.LongDeserializer(Long.class, null));
        simpleModule.addDeserializer(Double.class, (JsonDeserializer)new NumberDeserializers.DoubleDeserializer(Double.class, null));
        simpleModule.addDeserializer(Double.class, (JsonDeserializer)new NumberDeserializers.DoubleDeserializer(Double.class, null));
        simpleModule.addDeserializer(BigDecimal.class, (JsonDeserializer)new NumberDeserializers.BigDecimalDeserializer());
        return simpleModule;
    }

    public static ObjectMapper newObjectMapper() {
        return BeanConvert.newObjectMapper(BeanConvert.newSimpleModule());
    }

    public static ObjectMapper newObjectMapper(SimpleModule simpleModule) {
        return new ObjectMapper().registerModule((Module)simpleModule).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u5c06\u5b57\u7b26\u4e32[" + json + "]\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public static <T> T fromJson(String json, JavaType type) {
        try {
            return (T)MAPPER.readValue(json, type);
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u5c06\u5b57\u7b26\u4e32[" + json + "]\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public static <T> T fromJson(String json, TypeReference<T> typeReference) {
        try {
            return (T)MAPPER.readValue(json, typeReference);
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u5c06\u5b57\u7b26\u4e32[" + json + "]\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public static <T> List<T> fromJsonToList(String json, Class<T> entityClazz) {
        try {
            return (List)MAPPER.readValue(json, (JavaType)MAPPER.getTypeFactory().constructCollectionType(ArrayList.class, entityClazz));
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u5b57\u7b26\u4e32[" + json + "]\u8f6c\u6362\u4e3a\u96c6\u5408\u6570\u636e\u5931\u8d25", e);
        }
    }

    public static <T> UnifyPageData<T> fromJsonToPagedList(String json, Class<T> entityClazz) {
        try {
            JavaType tp = MAPPER.getTypeFactory().constructParametricType(UnifyPageData.class, new Class[]{entityClazz});
            return (UnifyPageData)MAPPER.readValue(json, tp);
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u5b57\u7b26\u4e32[" + json + "]\u8f6c\u6362\u4e3a\u5206\u9875\u6570\u636e\u5931\u8d25", e);
        }
    }

    public static String toJson(Object obj) {
        try {
            return MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u5c06\u5bf9\u8c61\u8f6c\u6362\u4e3a\u5b57\u7b26\u4e32\u5931\u8d25", e);
        }
    }

    public static List<Map<String, Object>> toMapList(Iterable<?> list, String ... fields) {
        try {
            String json = MAPPER.writeValueAsString(list);
            List map = (List)MAPPER.readValue(json, List.class);
            if (fields != null && fields.length > 0) {
                for (Map entity : map) {
                    BeanConvert.removeWithout(entity, fields);
                }
            }
            return map;
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u5c06list:" + list + "\u8f6c\u6362\u4e3amap\u5931\u8d25", e);
        }
    }

    public static <T> List<Map<String, Object>> toMapList(T[] array, String ... fields) {
        try {
            String json = MAPPER.writeValueAsString(array);
            List map = (List)MAPPER.readValue(json, List.class);
            if (fields != null && fields.length > 0) {
                for (Map entity : map) {
                    BeanConvert.removeWithout(entity, fields);
                }
            }
            return map;
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u5c06\u6570\u7ec4:" + array + "\u8f6c\u6362\u4e3amap\u5931\u8d25", e);
        }
    }

    public static UnifyPageData<Map<String, Object>> toMapList(UnifyPageData<?> data, String ... fields) {
        UnifyPageData<Map<String, Object>> pagedData = null;
        if (data != null && data.getList() != null) {
            List<Map<String, Object>> dataList = BeanConvert.toMapList(data.getList(), fields);
            pagedData = new UnifyPageData<Map<String, Object>>(dataList, data.getPageIndex(), data.getPageSize(), data.getTotalSize());
        } else {
            pagedData = new UnifyPageData<Map<String, Object>>(new ArrayList(), data.getPageIndex(), data.getPageSize(), data.getTotalSize());
        }
        return pagedData;
    }

    public static List<Map<String, Object>> toMapList(Object obj, String ... fields) {
        if (obj instanceof Iterable) {
            return BeanConvert.toMapList((Iterable)obj, fields);
        }
        try {
            String json = MAPPER.writeValueAsString(obj);
            List map = (List)MAPPER.readValue(json, List.class);
            if (fields != null && fields.length > 0) {
                for (Map entity : map) {
                    BeanConvert.removeWithout(entity, fields);
                }
            }
            return map;
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u5c06\u5bf9\u8c61:" + obj + "\u8f6c\u6362\u4e3amap\u5931\u8d25", e);
        }
    }

    public static Map<String, Object> toMap(Object bean, String ... fields) {
        if (bean instanceof Map) {
            return (Map)bean;
        }
        try {
            String json = MAPPER.writeValueAsString(bean);
            Map map = (Map)MAPPER.readValue(json, Map.class);
            if (fields != null && fields.length > 0) {
                BeanConvert.removeWithout(map, fields);
            }
            return map;
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u5c06bean:" + bean + "\u8f6c\u6362\u4e3amap\u5931\u8d25", e);
        }
    }

    public static Map<String, Object> toMapDelayering(Object bean) {
        try {
            String json = MAPPER.writeValueAsString(bean);
            Map map = (Map)MAPPER.readValue(json, Map.class);
            TreeMap<String, Object> result = new TreeMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                Map<String, Object> del = BeanConvert.delayering((String)entry.getKey(), entry.getValue());
                for (Map.Entry<String, Object> e : del.entrySet()) {
                    result.put(e.getKey(), e.getValue());
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u5c06bean:" + bean + "\u8f6c\u6362\u4e3amap\u5931\u8d25", e);
        }
    }

    private static Map<String, Object> delayering(String key, Object obj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (obj == null) {
            result.put(key, null);
        } else if (obj instanceof Map) {
            key = key == null ? "" : key + ".";
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                result.putAll(BeanConvert.delayering(key + (String)entry.getKey(), entry.getValue()));
            }
        } else if (obj instanceof Collection) {
            if (key == null) {
                key = "";
            }
            int idx = 0;
            for (Object o : (Collection)obj) {
                result.putAll(BeanConvert.delayering(key + "[" + idx + "]", o));
                ++idx;
            }
        } else {
            result.put(key, obj);
        }
        return result;
    }

    public static <T> T fromMap(Map<String, Object> map, Class<T> classOfT) {
        try {
            String json = MAPPER.writeValueAsString(map);
            return (T)MAPPER.readValue(json, classOfT);
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u5c06map:" + map + "\u8f6c\u6362\u4e3a" + classOfT.getName() + "\u5931\u8d25", e);
        }
    }

    private static void removeWithout(Map<String, Object> map, String ... fields) {
        ArrayList<String> ks = new ArrayList<String>(map.keySet());
        for (String k : ks) {
            if (ArraysUtil.contains(fields, k)) continue;
            map.remove(k);
        }
    }
}

