/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.util;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESSecurity {
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String CBC_CIPHER_ALGORITHM = "AES/CBC/PKCS7Padding";
    private static Logger logger = LoggerFactory.getLogger(AESSecurity.class);
    private ThreadLocal<Cipher> encryptCipher = new ThreadLocal();
    private ThreadLocal<Cipher> decryptCipher = new ThreadLocal();
    private byte[] key;
    private byte[] iv;

    public AESSecurity(String keyStr) {
        try {
            this.key = keyStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "AES\u5bc6\u7801\u4e0d\u5339\u914d");
        }
    }

    public AESSecurity(byte[] key) {
        this.key = key;
    }

    public AESSecurity(byte[] key, byte[] iv) {
        this.key = key;
        this.iv = iv;
    }

    private Cipher getEncryptCipher() {
        try {
            Cipher cipher = this.encryptCipher.get();
            if (cipher == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
                if (this.iv == null) {
                    cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
                    cipher.init(1, this.getSecretKey(this.key));
                    this.encryptCipher.set(cipher);
                } else {
                    cipher = Cipher.getInstance(CBC_CIPHER_ALGORITHM, "BC");
                    AlgorithmParameters parameters = AlgorithmParameters.getInstance(KEY_ALGORITHM);
                    parameters.init(new IvParameterSpec(this.iv));
                    cipher.init(1, (Key)this.getSecretKey(this.key), parameters);
                    this.encryptCipher.set(cipher);
                }
            }
            return cipher;
        }
        catch (Exception e) {
            throw new UnifyException("\u521b\u5efa\u52a0\u5bc6\u5668\u5931\u8d25", (Throwable)e);
        }
    }

    private Cipher getDecryptCipher() {
        try {
            Cipher cipher = this.decryptCipher.get();
            if (cipher == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
                if (this.iv == null) {
                    cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
                    cipher.init(2, this.getSecretKey(this.key));
                    this.decryptCipher.set(cipher);
                } else {
                    cipher = Cipher.getInstance(CBC_CIPHER_ALGORITHM, "BC");
                    AlgorithmParameters parameters = AlgorithmParameters.getInstance(KEY_ALGORITHM);
                    parameters.init(new IvParameterSpec(this.iv));
                    cipher.init(2, (Key)this.getSecretKey(this.key), parameters);
                    this.decryptCipher.set(cipher);
                }
            }
            return cipher;
        }
        catch (Exception e) {
            throw new UnifyException("\u521b\u5efa\u89e3\u5bc6\u5668\u5931\u8d25", (Throwable)e);
        }
    }

    public String encrypt(String content) {
        try {
            Cipher cipher = this.getEncryptCipher();
            byte[] byteContent = content.getBytes("utf-8");
            byte[] result = cipher.doFinal(byteContent);
            return Base64.getEncoder().encodeToString(result);
        }
        catch (Exception ex) {
            throw new UnifyException("\u4fe1\u606f\u52a0\u5bc6\u5931\u8d25", (Throwable)ex);
        }
    }

    public byte[] encrypt(byte[] byteContent) {
        try {
            Cipher cipher = this.getEncryptCipher();
            byte[] result = cipher.doFinal(byteContent);
            return result;
        }
        catch (Exception ex) {
            throw new UnifyException("\u4fe1\u606f\u52a0\u5bc6\u5931\u8d25", (Throwable)ex);
        }
    }

    public String decrypt(String content) {
        try {
            Cipher cipher = this.getDecryptCipher();
            byte[] result = cipher.doFinal(Base64.getDecoder().decode(content));
            return new String(result, "utf-8");
        }
        catch (Exception ex) {
            throw new UnifyException("\u4fe1\u606f\u89e3\u5bc6\u5931\u8d25", (Throwable)ex);
        }
    }

    public byte[] decrypt(byte[] byteContent) {
        try {
            Cipher cipher = this.getDecryptCipher();
            byte[] result = cipher.doFinal(byteContent);
            return result;
        }
        catch (Exception ex) {
            throw new UnifyException("\u4fe1\u606f\u89e3\u5bc6\u5931\u8d25", (Throwable)ex);
        }
    }

    private SecretKeySpec getSecretKey(byte[] bytes) throws Exception {
        if (bytes.length != 16) {
            throw new UnifyException("AES\u5bc6\u94a5\u957f\u5ea6\u5fc5\u987b\u4e3a16");
        }
        return new SecretKeySpec(bytes, KEY_ALGORITHM);
    }
}

