/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.stream;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCloseInputStreamWapper
extends InputStream {
    Logger logger = LoggerFactory.getLogger(AutoCloseInputStreamWapper.class);
    InputStream stream = null;
    Closeable[] closeables;

    public AutoCloseInputStreamWapper(InputStream stream, Closeable ... closeables) {
        this.stream = stream;
        this.closeables = closeables;
    }

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.stream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream.close();
        }
        catch (Exception e) {
            this.logger.warn("\u8f93\u5165\u6d41\u5173\u95ed\u5931\u8d25", (Throwable)e);
        }
        if (this.closeables != null) {
            for (Closeable c : this.closeables) {
                try {
                    c.close();
                }
                catch (Exception e) {
                    this.logger.warn("\u8f93\u5165\u6d41\u5173\u95ed\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }
}

